/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions;

import java.util.List;
import org.apache.flink.api.common.functions.RichFlatJoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.tuples.EdgeWithTiePoint;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.tuples.ExpandEmbedding;

@FunctionAnnotation.ForwardedFieldsFirst(value={"f0"})
@FunctionAnnotation.ForwardedFieldsSecond(value={"f2"})
public class MergeExpandEmbeddings
extends RichFlatJoinFunction<ExpandEmbedding, EdgeWithTiePoint, ExpandEmbedding> {
    private final List<Integer> distinctVertices;
    private final List<Integer> distinctEdges;
    private final int closingColumn;

    public MergeExpandEmbeddings(List<Integer> distinctVertices, List<Integer> distinctEdges, int closingColumn) {
        this.distinctVertices = distinctVertices;
        this.distinctEdges = distinctEdges;
        this.closingColumn = closingColumn;
    }

    public void join(ExpandEmbedding base, EdgeWithTiePoint edge, Collector<ExpandEmbedding> out) throws Exception {
        if (this.checkDistinctiveness(base, edge)) {
            out.collect((Object)base.grow(edge));
        }
    }

    private boolean checkDistinctiveness(ExpandEmbedding prev, EdgeWithTiePoint edge) {
        List<GradoopId> ref;
        if (this.distinctVertices.isEmpty() && this.distinctEdges.isEmpty()) {
            return true;
        }
        if (edge.getSource().equals((Object)edge.getTarget()) && !this.distinctVertices.isEmpty()) {
            return false;
        }
        for (GradoopId ref2 : prev.getPath()) {
            if (!ref2.equals((Object)edge.getSource()) && (!ref2.equals((Object)edge.getTarget()) || this.distinctVertices.isEmpty()) && (!ref2.equals((Object)edge.getId()) || this.distinctEdges.isEmpty())) continue;
            return false;
        }
        for (int i : this.distinctVertices) {
            ref = prev.getBase().getIdAsList(i);
            if ((!ref.contains(edge.getTarget()) || i == this.closingColumn) && !ref.contains(edge.getSource())) continue;
            return false;
        }
        ref = prev.getBase().getIdsAsList(this.distinctEdges);
        return !ref.contains(edge.getId());
    }
}

