/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.functions;

import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.tuples.ExpandEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;

public class PostProcessExpandEmbedding
extends RichFlatMapFunction<ExpandEmbedding, Embedding> {
    private final int minPathLength;
    private final int closingColumn;

    public PostProcessExpandEmbedding(int lowerBound, int closingColumn) {
        this.minPathLength = lowerBound * 2 - 1;
        this.closingColumn = closingColumn;
    }

    public void flatMap(ExpandEmbedding value, Collector<Embedding> out) throws Exception {
        if (value.pathSize() < this.minPathLength) {
            return;
        }
        if (this.closingColumn >= 0 && !value.getBase().getId(this.closingColumn).equals((Object)value.getEnd())) {
            return;
        }
        out.collect((Object)value.toEmbedding());
    }
}

