/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.filter.functions;

import java.util.List;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphElement;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingFactory;

public class FilterAndProjectEdge<E extends Edge>
extends RichFlatMapFunction<E, Embedding> {
    private final CNF predicates;
    private final List<String> projectionPropertyKeys;
    private boolean isLoop;

    public FilterAndProjectEdge(CNF predicates, List<String> projectionPropertyKeys, boolean isLoop) {
        this.predicates = predicates;
        this.projectionPropertyKeys = projectionPropertyKeys;
        this.isLoop = isLoop;
    }

    public void flatMap(E edge, Collector<Embedding> out) throws Exception {
        if (this.predicates.evaluate((GraphElement)edge)) {
            out.collect((Object)EmbeddingFactory.fromEdge(edge, this.projectionPropertyKeys, this.isLoop));
        }
    }
}

