/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.filter.functions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingFactory;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Triple;

public class FilterAndProjectTriple
extends RichFlatMapFunction<Triple, Embedding> {
    private final CNF predicates;
    private final String sourceVariable;
    private final String targetVariable;
    private final List<String> sourceProjectionPropertyKeys;
    private final List<String> edgeProjectionPropertyKeys;
    private final List<String> targetProjectionPropertyKeys;
    private final EmbeddingMetaData filterMetaData;
    private final List<String> sourceFilterPropertyKeys;
    private final List<String> edgeFilterPropertyKeys;
    private final List<String> targetFilterPropertyKeys;
    private final boolean isLoop;
    private final boolean isVertexIso;

    public FilterAndProjectTriple(String sourceVariable, String edgeVariable, String targetVariable, CNF predicates, Map<String, List<String>> projectionPropertyKeys, MatchStrategy vertexMatchStrategy) {
        this.predicates = predicates;
        this.sourceVariable = sourceVariable;
        this.targetVariable = targetVariable;
        this.sourceProjectionPropertyKeys = projectionPropertyKeys.getOrDefault(sourceVariable, new ArrayList());
        this.edgeProjectionPropertyKeys = projectionPropertyKeys.getOrDefault(edgeVariable, new ArrayList());
        this.targetProjectionPropertyKeys = projectionPropertyKeys.getOrDefault(targetVariable, new ArrayList());
        this.isLoop = sourceVariable.equals(targetVariable);
        this.isVertexIso = vertexMatchStrategy.equals((Object)MatchStrategy.ISOMORPHISM);
        this.filterMetaData = FilterAndProjectTriple.createFilterMetaData(predicates, sourceVariable, edgeVariable, targetVariable);
        this.sourceFilterPropertyKeys = this.filterMetaData.getPropertyKeys(sourceVariable);
        this.edgeFilterPropertyKeys = this.filterMetaData.getPropertyKeys(edgeVariable);
        this.targetFilterPropertyKeys = this.filterMetaData.getPropertyKeys(targetVariable);
    }

    public void flatMap(Triple triple, Collector<Embedding> out) throws Exception {
        boolean isValid = true;
        if (this.isLoop) {
            if (!triple.getSourceId().equals((Object)triple.getTargetId())) {
                isValid = false;
            }
        } else if (this.isVertexIso && triple.getSourceId().equals((Object)triple.getTargetId())) {
            isValid = false;
        }
        if (isValid && this.filter(triple)) {
            out.collect((Object)EmbeddingFactory.fromTriple(triple, this.sourceProjectionPropertyKeys, this.edgeProjectionPropertyKeys, this.targetProjectionPropertyKeys, this.sourceVariable, this.targetVariable));
        }
    }

    private boolean filter(Triple triple) {
        return this.predicates.evaluate(EmbeddingFactory.fromTriple(triple, this.sourceFilterPropertyKeys, this.edgeFilterPropertyKeys, this.targetFilterPropertyKeys, this.sourceVariable, this.targetVariable), this.filterMetaData);
    }

    private static EmbeddingMetaData createFilterMetaData(CNF predicates, String sourceVariable, String edgeVariable, String targetVariable) {
        EmbeddingMetaData metaData = new EmbeddingMetaData();
        metaData.setEntryColumn(sourceVariable, EmbeddingMetaData.EntryType.VERTEX, 0);
        metaData.setEntryColumn(edgeVariable, EmbeddingMetaData.EntryType.EDGE, 1);
        metaData.setEntryColumn(targetVariable, EmbeddingMetaData.EntryType.VERTEX, 2);
        int i = 0;
        for (String variable : new String[]{sourceVariable, edgeVariable, targetVariable}) {
            for (String propertyKey : predicates.getPropertyKeys(variable)) {
                metaData.setPropertyColumn(variable, propertyKey, i++);
            }
        }
        return metaData;
    }
}

