/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.filter.functions;

import java.util.List;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.GraphElement;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingFactory;

public class FilterAndProjectVertex<V extends Vertex>
extends RichFlatMapFunction<V, Embedding> {
    private final CNF predicates;
    private final List<String> projectionPropertyKeys;

    public FilterAndProjectVertex(CNF predicates, List<String> projectionPropertyKeys) {
        this.predicates = predicates;
        this.projectionPropertyKeys = projectionPropertyKeys;
    }

    public void flatMap(V vertex, Collector<Embedding> out) throws Exception {
        if (this.predicates.evaluate((GraphElement)vertex)) {
            out.collect((Object)EmbeddingFactory.fromVertex(vertex, this.projectionPropertyKeys));
        }
    }
}

