/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.PhysicalOperator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.functions.MergeEmbeddings;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;

public class CartesianProduct
implements PhysicalOperator {
    private final DataSet<Embedding> left;
    private final DataSet<Embedding> right;
    private final int rightColumns;
    private final List<Integer> distinctVertexColumnsLeft;
    private final List<Integer> distinctVertexColumnsRight;
    private final List<Integer> distinctEdgeColumnsLeft;
    private final List<Integer> distinctEdgeColumnsRight;
    private final CrossOperatorBase.CrossHint crossHint;
    private String name;

    public CartesianProduct(DataSet<Embedding> left, DataSet<Embedding> right, int rightColumns, List<Integer> distinctVertexColumnsLeft, List<Integer> distinctVertexColumnsRight, List<Integer> distinctEdgeColumnsLeft, List<Integer> distinctEdgeColumnsRight, CrossOperatorBase.CrossHint crossHint) {
        this.left = left;
        this.right = right;
        this.rightColumns = rightColumns;
        this.distinctVertexColumnsLeft = distinctVertexColumnsLeft;
        this.distinctVertexColumnsRight = distinctVertexColumnsRight;
        this.distinctEdgeColumnsLeft = distinctEdgeColumnsLeft;
        this.distinctEdgeColumnsRight = distinctEdgeColumnsRight;
        this.crossHint = crossHint;
        this.setName("CartesianProduct");
    }

    @Override
    public DataSet<Embedding> evaluate() {
        return this.left.cross(this.right).flatMap((FlatMapFunction)new MergeEmbeddings(this.rightColumns, Lists.newArrayListWithCapacity((int)0), this.distinctVertexColumnsLeft, this.distinctVertexColumnsRight, this.distinctEdgeColumnsLeft, this.distinctEdgeColumnsRight)).name(this.getName());
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

