/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.PhysicalOperator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.functions.ExtractJoinColumns;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.functions.MergeEmbeddings;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;

public class JoinEmbeddings
implements PhysicalOperator {
    private final DataSet<Embedding> left;
    private final DataSet<Embedding> right;
    private final int rightColumns;
    private final List<Integer> leftJoinColumns;
    private final List<Integer> rightJoinColumns;
    private final List<Integer> distinctVertexColumnsLeft;
    private final List<Integer> distinctVertexColumnsRight;
    private final List<Integer> distinctEdgeColumnsLeft;
    private final List<Integer> distinctEdgeColumnsRight;
    private final JoinOperatorBase.JoinHint joinHint;
    private String name;

    public JoinEmbeddings(DataSet<Embedding> left, DataSet<Embedding> right, int rightColumns, int leftJoinColumn, int rightJoinColumn) {
        this(left, right, rightColumns, Collections.singletonList(leftJoinColumn), Collections.singletonList(rightJoinColumn));
    }

    public JoinEmbeddings(DataSet<Embedding> left, DataSet<Embedding> right, int rightColumns, List<Integer> leftJoinColumns, List<Integer> rightJoinColumns) {
        this(left, right, rightColumns, leftJoinColumns, rightJoinColumns, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public JoinEmbeddings(DataSet<Embedding> left, DataSet<Embedding> right, int rightColumns, List<Integer> leftJoinColumns, List<Integer> rightJoinColumns, List<Integer> distinctVertexColumnsLeft, List<Integer> distinctVertexColumnsRight, List<Integer> distinctEdgeColumnsLeft, List<Integer> distinctEdgeColumnsRight) {
        this(left, right, rightColumns, leftJoinColumns, rightJoinColumns, distinctVertexColumnsLeft, distinctVertexColumnsRight, distinctEdgeColumnsLeft, distinctEdgeColumnsRight, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
    }

    public JoinEmbeddings(DataSet<Embedding> left, DataSet<Embedding> right, int rightColumns, List<Integer> leftJoinColumns, List<Integer> rightJoinColumns, List<Integer> distinctVertexColumnsLeft, List<Integer> distinctVertexColumnsRight, List<Integer> distinctEdgeColumnsLeft, List<Integer> distinctEdgeColumnsRight, JoinOperatorBase.JoinHint joinHint) {
        this.left = left;
        this.right = right;
        this.rightColumns = rightColumns;
        this.leftJoinColumns = leftJoinColumns;
        this.rightJoinColumns = rightJoinColumns;
        this.distinctVertexColumnsLeft = distinctVertexColumnsLeft;
        this.distinctVertexColumnsRight = distinctVertexColumnsRight;
        this.distinctEdgeColumnsLeft = distinctEdgeColumnsLeft;
        this.distinctEdgeColumnsRight = distinctEdgeColumnsRight;
        this.joinHint = joinHint;
        this.setName("JoinEmbeddings");
    }

    @Override
    public DataSet<Embedding> evaluate() {
        return this.left.join(this.right, this.joinHint).where((KeySelector)new ExtractJoinColumns(this.leftJoinColumns)).equalTo((KeySelector)new ExtractJoinColumns(this.rightJoinColumns)).with((FlatJoinFunction)new MergeEmbeddings(this.rightColumns, this.rightJoinColumns, this.distinctVertexColumnsLeft, this.distinctVertexColumnsRight, this.distinctEdgeColumnsLeft, this.distinctEdgeColumnsRight)).name(this.getName());
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

