/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.functions.KeySelector;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.PhysicalOperator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.functions.ExtractPropertyJoinColumns;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.functions.MergeEmbeddings;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;

public class ValueJoin
implements PhysicalOperator {
    private final DataSet<Embedding> left;
    private final DataSet<Embedding> right;
    private final List<Integer> leftJoinProperties;
    private final List<Integer> rightJoinProperties;
    private final int rightColumns;
    private final List<Integer> distinctVertexColumnsLeft;
    private final List<Integer> distinctVertexColumnsRight;
    private final List<Integer> distinctEdgeColumnsLeft;
    private final List<Integer> distinctEdgeColumnsRight;
    private final JoinOperatorBase.JoinHint joinHint;
    private String name;

    public ValueJoin(DataSet<Embedding> left, DataSet<Embedding> right, List<Integer> leftJoinProperties, List<Integer> rightJoinProperties, int rightColumns) {
        this(left, right, leftJoinProperties, rightJoinProperties, rightColumns, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
    }

    public ValueJoin(DataSet<Embedding> left, DataSet<Embedding> right, List<Integer> leftJoinProperties, List<Integer> rightJoinProperties, int rightColumns, List<Integer> distinctVertexColumnsLeft, List<Integer> distinctVertexColumnsRight, List<Integer> distinctEdgeColumnsLeft, List<Integer> distinctEdgeColumnsRight, JoinOperatorBase.JoinHint joinHint) {
        this.left = left;
        this.right = right;
        this.leftJoinProperties = leftJoinProperties;
        this.rightJoinProperties = rightJoinProperties;
        this.rightColumns = rightColumns;
        this.distinctVertexColumnsLeft = distinctVertexColumnsLeft;
        this.distinctVertexColumnsRight = distinctVertexColumnsRight;
        this.distinctEdgeColumnsLeft = distinctEdgeColumnsLeft;
        this.distinctEdgeColumnsRight = distinctEdgeColumnsRight;
        this.joinHint = joinHint;
        this.setName("ValueJoin");
    }

    @Override
    public DataSet<Embedding> evaluate() {
        return this.left.join(this.right, this.joinHint).where((KeySelector)new ExtractPropertyJoinColumns(this.leftJoinProperties)).equalTo((KeySelector)new ExtractPropertyJoinColumns(this.rightJoinProperties)).with((FlatJoinFunction)new MergeEmbeddings(this.rightColumns, Lists.newArrayListWithCapacity((int)0), this.distinctVertexColumnsLeft, this.distinctVertexColumnsRight, this.distinctEdgeColumnsLeft, this.distinctEdgeColumnsRight)).name(this.getName());
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

