/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.functions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;

public class MergeEmbeddings
implements FlatJoinFunction<Embedding, Embedding, Embedding>,
FlatMapFunction<Tuple2<Embedding, Embedding>, Embedding> {
    protected final Embedding reuseEmbedding;
    private final int[] nonJoinColumnsRight;
    private final int joinColumnsRightSize;
    private final int[] distinctVertexColumnsLeft;
    private final int[] distinctVertexColumnsRight;
    private final int[] distinctEdgeColumnsLeft;
    private final int[] distinctEdgeColumnsRight;
    private final boolean checkDistinctVertices;
    private final boolean checkDistinctEdges;

    public MergeEmbeddings(int rightColumns, List<Integer> joinColumnsRight, List<Integer> distinctVertexColumnsLeft, List<Integer> distinctVertexColumnsRight, List<Integer> distinctEdgeColumnsLeft, List<Integer> distinctEdgeColumnsRight) {
        this.nonJoinColumnsRight = IntStream.range(0, rightColumns).filter(col -> !joinColumnsRight.contains(col)).toArray();
        this.joinColumnsRightSize = joinColumnsRight.size();
        ToIntFunction<Integer> f = i -> i;
        this.distinctVertexColumnsLeft = distinctVertexColumnsLeft.stream().mapToInt(f).toArray();
        this.distinctVertexColumnsRight = distinctVertexColumnsRight.stream().mapToInt(f).toArray();
        this.distinctEdgeColumnsLeft = distinctEdgeColumnsLeft.stream().mapToInt(f).toArray();
        this.distinctEdgeColumnsRight = distinctEdgeColumnsRight.stream().mapToInt(f).toArray();
        this.checkDistinctVertices = distinctVertexColumnsLeft.size() > 0 || distinctVertexColumnsRight.size() > 0;
        this.checkDistinctEdges = distinctEdgeColumnsLeft.size() > 0 || distinctEdgeColumnsRight.size() > 0;
        this.reuseEmbedding = new Embedding();
    }

    public void join(Embedding left, Embedding right, Collector<Embedding> out) throws Exception {
        if (this.isValid(left, right)) {
            this.buildEmbedding(left, right);
            out.collect((Object)this.reuseEmbedding);
        }
    }

    public void flatMap(Tuple2<Embedding, Embedding> value, Collector<Embedding> out) throws Exception {
        this.join((Embedding)value.f0, (Embedding)value.f1, out);
    }

    protected boolean isValid(Embedding left, Embedding right) {
        boolean collect = false;
        if (!this.checkDistinctVertices && !this.checkDistinctEdges) {
            collect = true;
        } else if (!this.checkDistinctVertices) {
            if (this.isDistinct(this.distinctEdgeColumnsLeft, this.distinctEdgeColumnsRight, left, right)) {
                collect = true;
            }
        } else if (this.isDistinct(this.distinctVertexColumnsLeft, this.distinctVertexColumnsRight, left, right) && this.isDistinct(this.distinctEdgeColumnsLeft, this.distinctEdgeColumnsRight, left, right)) {
            collect = true;
        }
        return collect;
    }

    protected void buildEmbedding(Embedding left, Embedding right) {
        this.reuseEmbedding.setIdData(this.mergeIdData(left, right));
        this.reuseEmbedding.setPropertyData(this.mergePropertyData(left, right));
        this.reuseEmbedding.setIdListData(this.mergeIdListData(left, right));
    }

    private boolean isDistinct(int[] columnsLeft, int[] columnsRight, Embedding left, Embedding right) {
        HashSet<GradoopId> ids = new HashSet<GradoopId>(left.size() + right.size());
        return this.isDistinct(ids, columnsLeft, left) && this.isDistinct(ids, columnsRight, right);
    }

    private boolean isDistinct(Set<GradoopId> ids, int[] columns, Embedding embedding) {
        int column;
        boolean isDistinct = true;
        int[] nArray = columns;
        int n = nArray.length;
        for (int i = 0; i < n && (isDistinct = ids.addAll(embedding.getIdAsList(column = nArray[i]))); ++i) {
        }
        return isDistinct;
    }

    private byte[] mergeIdData(Embedding left, Embedding right) {
        byte[] newIdData = new byte[left.getIdData().length + right.getIdData().length - this.joinColumnsRightSize * 13];
        int offset = left.getIdData().length;
        System.arraycopy(left.getIdData(), 0, newIdData, 0, offset);
        for (int i : this.nonJoinColumnsRight) {
            System.arraycopy(right.getRawIdEntry(i), 0, newIdData, offset, 13);
            offset += 13;
        }
        return newIdData;
    }

    private byte[] mergePropertyData(Embedding left, Embedding right) {
        return ArrayUtils.addAll((byte[])left.getPropertyData(), (byte[])right.getPropertyData());
    }

    private byte[] mergeIdListData(Embedding left, Embedding right) {
        return ArrayUtils.addAll((byte[])left.getIdListData(), (byte[])right.getIdListData());
    }
}

