/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation;

import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;

abstract class Estimator {
    private final QueryHandler queryHandler;
    private final GraphStatistics graphStatistics;

    Estimator(QueryHandler queryHandler, GraphStatistics graphStatistics) {
        this.queryHandler = queryHandler;
        this.graphStatistics = graphStatistics;
    }

    public QueryHandler getQueryHandler() {
        return this.queryHandler;
    }

    public GraphStatistics getGraphStatistics() {
        return this.graphStatistics;
    }

    String getLabel(String variable, boolean isVertex) {
        return isVertex ? this.queryHandler.getVertexByVariable(variable).getLabel() : this.queryHandler.getEdgeByVariable(variable).getLabel();
    }

    long getCardinality(String label, boolean isVertex) {
        long cardinality;
        long l = cardinality = isVertex ? this.graphStatistics.getVertexCount(label) : this.graphStatistics.getEdgeCount(label);
        return cardinality > 0L ? cardinality : (isVertex ? this.graphStatistics.getVertexCount() : this.graphStatistics.getEdgeCount());
    }
}

