/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation;

import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation.Estimator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.FilterNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.leaf.FilterAndProjectEdgesNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.leaf.FilterAndProjectVerticesNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.unary.FilterEmbeddingsNode;

class FilterEstimator
extends Estimator {
    private long cardinality;
    private double selectivity = 1.0;

    FilterEstimator(QueryHandler queryHandler, GraphStatistics graphStatistics) {
        super(queryHandler, graphStatistics);
    }

    void visit(FilterNode node) {
        if (node instanceof FilterAndProjectVerticesNode) {
            FilterAndProjectVerticesNode vertexNode = (FilterAndProjectVerticesNode)node;
            this.setCardinality(vertexNode.getEmbeddingMetaData().getVertexVariables().get(0), true);
            this.updateSelectivity(vertexNode.getFilterPredicate());
        } else if (node instanceof FilterAndProjectEdgesNode) {
            FilterAndProjectEdgesNode edgeNode = (FilterAndProjectEdgesNode)node;
            this.setCardinality(edgeNode.getEmbeddingMetaData().getEdgeVariables().get(0), false);
            this.updateSelectivity(edgeNode.getFilterPredicate());
        } else if (node instanceof FilterEmbeddingsNode) {
            this.updateSelectivity(((FilterEmbeddingsNode)node).getFilterPredicate());
        }
    }

    long getCardinality() {
        return this.cardinality;
    }

    double getSelectivity() {
        return this.selectivity;
    }

    private void setCardinality(String variable, boolean isVertex) {
        this.cardinality = this.getCardinality(this.getLabel(variable, isVertex), isVertex);
    }

    private void updateSelectivity(CNF predicates) {
    }
}

