/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation.Estimator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.JoinNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.LeafNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;
import org.s1ck.gdl.model.Edge;

class JoinEstimator
extends Estimator {
    private final Map<String, Long> cardinalities = new HashMap<String, Long>();
    private final Map<String, List<Long>> distinctValues = new HashMap<String, List<Long>>();

    JoinEstimator(QueryHandler queryHandler, GraphStatistics graphStatistics) {
        super(queryHandler, graphStatistics);
    }

    void visit(JoinNode node) {
        if (node instanceof BinaryNode) {
            BinaryNode binaryNode = (BinaryNode)((Object)node);
            if (binaryNode.getLeftChild() instanceof LeafNode) {
                this.process(binaryNode.getLeftChild().getEmbeddingMetaData());
            }
            if (binaryNode.getRightChild() instanceof LeafNode) {
                this.process(binaryNode.getRightChild().getEmbeddingMetaData());
            }
        }
    }

    long getCardinality() {
        long numerator = this.cardinalities.values().stream().reduce((i, j) -> i * j).orElse(0L);
        long denominator = this.distinctValues.values().stream().map(list -> list.stream().sorted().collect(Collectors.toList())).map(list -> list.subList(1, list.size())).flatMap(Collection::stream).reduce((i, j) -> i * j).orElse(1L);
        return Math.round(1.0 * (double)numerator / (double)denominator);
    }

    private void process(EmbeddingMetaData metaData) {
        int entryCount = metaData.getEntryCount();
        List<String> variables = metaData.getVariables();
        if (entryCount == 1) {
            this.processVertex(variables.get(0));
        } else {
            String edgeVariable = variables.get(1);
            String sourceVariable = this.getQueryHandler().getVertexById(this.getQueryHandler().getEdgeByVariable(edgeVariable).getSourceVertexId()).getVariable();
            String targetVariable = this.getQueryHandler().getVertexById(this.getQueryHandler().getEdgeByVariable(edgeVariable).getTargetVertexId()).getVariable();
            this.processEdge(sourceVariable, variables.get(1), targetVariable);
        }
    }

    private void processVertex(String vertexVariable) {
        String label = this.getLabel(vertexVariable, true);
        long cardinality = this.getCardinality(label, true);
        this.updateCardinality(vertexVariable, cardinality);
        this.updateDistinctValues(vertexVariable, cardinality);
    }

    private void processEdge(String sourceVariable, String edgeVariable, String targetVariable) {
        Edge queryEdge;
        long distinctTargetCount;
        String edgeLabel = this.getLabel(edgeVariable, false);
        long distinctSourceCount = this.getGraphStatistics().getDistinctSourceVertexCount(edgeLabel);
        if (distinctSourceCount == 0L) {
            distinctSourceCount = this.getGraphStatistics().getDistinctSourceVertexCount();
        }
        if ((distinctTargetCount = this.getGraphStatistics().getDistinctTargetVertexCount(edgeLabel)) == 0L) {
            distinctTargetCount = this.getGraphStatistics().getDistinctTargetVertexCount();
        }
        if ((queryEdge = this.getQueryHandler().getEdgeByVariable(edgeVariable)).getUpperBound() > 1) {
            this.updateCardinality(edgeVariable, this.getPathCardinality(this.getCardinality(edgeLabel, false), queryEdge.getLowerBound(), queryEdge.getUpperBound(), distinctSourceCount, distinctTargetCount));
        } else {
            this.updateCardinality(edgeVariable, this.getCardinality(edgeLabel, false));
        }
        this.updateDistinctValues(sourceVariable, distinctSourceCount);
        this.updateDistinctValues(targetVariable, distinctTargetCount);
    }

    private long getPathCardinality(long edgeCardinality, int lowerBound, int upperBound, long distinctSourceCount, long distinctTargetCount) {
        double totalCardinality = 0.0;
        long probability = distinctSourceCount * distinctTargetCount;
        for (int i = lowerBound; i <= upperBound; ++i) {
            totalCardinality += Math.pow(edgeCardinality, i) / Math.pow(probability, i - 1);
        }
        return Math.round(totalCardinality);
    }

    private void updateCardinality(String variable, long cardinality) {
        this.cardinalities.put(variable, this.cardinalities.getOrDefault(variable, 1L) * cardinality);
    }

    private void updateDistinctValues(String variable, long count) {
        if (this.distinctValues.containsKey(variable)) {
            this.distinctValues.get(variable).add(count);
        } else {
            this.distinctValues.put(variable, Lists.newArrayList((Object[])new Long[]{count}));
        }
    }
}

