/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation;

import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation.FilterEstimator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation.JoinEstimator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.FilterNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.JoinNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.PlanNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.QueryPlan;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.UnaryNode;

public class QueryPlanEstimator {
    private final QueryPlan queryPlan;
    private final JoinEstimator joinEstimator;
    private final FilterEstimator filterEstimator;

    public QueryPlanEstimator(QueryPlan queryPlan, QueryHandler queryHandler, GraphStatistics graphStatistics) {
        this.queryPlan = queryPlan;
        this.joinEstimator = new JoinEstimator(queryHandler, graphStatistics);
        this.filterEstimator = new FilterEstimator(queryHandler, graphStatistics);
    }

    public QueryPlan getQueryPlan() {
        return this.queryPlan;
    }

    public long getCardinality() {
        this.traversePlan(this.queryPlan.getRoot());
        long cardinality = this.joinEstimator.getCardinality();
        if (cardinality == 0L) {
            cardinality = this.filterEstimator.getCardinality();
        }
        double selectivity = this.filterEstimator.getSelectivity();
        return Math.round((double)cardinality * selectivity);
    }

    private void traversePlan(PlanNode node) {
        if (node instanceof JoinNode) {
            this.joinEstimator.visit((JoinNode)((Object)node));
        }
        if (node instanceof FilterNode) {
            this.filterEstimator.visit((FilterNode)((Object)node));
        }
        if (node instanceof BinaryNode) {
            this.traversePlan(((BinaryNode)node).getLeftChild());
            this.traversePlan(((BinaryNode)node).getRightChild());
        }
        if (node instanceof UnaryNode) {
            this.traversePlan(((UnaryNode)node).getChildNode());
        }
    }
}

