/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.planner.greedy;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNFElement;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.QueryComparable;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.comparables.PropertySelectorComparable;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.expressions.ComparisonExpression;
import org.gradoop.flink.model.impl.operators.matching.common.statistics.GraphStatistics;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation.QueryPlanEstimator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.plantable.PlanTable;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.plantable.PlanTableEntry;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.QueryPlan;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary.CartesianProductNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary.ExpandEmbeddingsNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary.JoinEmbeddingsNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary.ValueJoinNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.leaf.FilterAndProjectEdgesNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.leaf.FilterAndProjectVerticesNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.unary.FilterEmbeddingsNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.unary.ProjectEmbeddingsNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.utils.ExpandDirection;
import org.s1ck.gdl.model.Edge;
import org.s1ck.gdl.model.Vertex;
import org.s1ck.gdl.utils.Comparator;

public class GreedyPlanner<G extends GraphHead, V extends org.gradoop.common.model.api.entities.Vertex, E extends org.gradoop.common.model.api.entities.Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> {
    private final LG graph;
    private final QueryHandler queryHandler;
    private final GraphStatistics graphStatistics;
    private final MatchStrategy vertexStrategy;
    private final MatchStrategy edgeStrategy;

    public GreedyPlanner(LG graph, QueryHandler queryHandler, GraphStatistics graphStatistics, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy) {
        this.graph = graph;
        this.queryHandler = queryHandler;
        this.graphStatistics = graphStatistics;
        this.vertexStrategy = vertexStrategy;
        this.edgeStrategy = edgeStrategy;
    }

    public PlanTableEntry plan() {
        PlanTable planTable = this.initPlanTable();
        while (planTable.size() > 1) {
            PlanTable newPlans = this.evaluateJoins(planTable);
            if (newPlans.size() == 0) {
                newPlans = this.evaluateCartesianProducts(planTable);
            }
            newPlans = this.evaluateFilter(newPlans);
            newPlans = this.evaluateProjection(newPlans);
            PlanTableEntry bestEntry = newPlans.min();
            planTable.removeCoveredBy(bestEntry);
            planTable.add(bestEntry);
        }
        return planTable.get(0);
    }

    private PlanTable initPlanTable() {
        PlanTable planTable = new PlanTable();
        this.createVertexPlans(planTable);
        this.createEdgePlans(planTable);
        return planTable;
    }

    private void createVertexPlans(PlanTable planTable) {
        for (Vertex vertex : this.queryHandler.getVertices()) {
            String vertexVariable = vertex.getVariable();
            CNF allPredicates = this.queryHandler.getPredicates();
            CNF vertexPredicates = allPredicates.removeSubCNF(vertexVariable);
            Set<String> projectionKeys = allPredicates.getPropertyKeys(vertexVariable);
            DataSet vertices = vertex.getLabel().equals("") ? this.graph.getVertices() : this.graph.getVerticesByLabel(vertex.getLabel());
            FilterAndProjectVerticesNode node = new FilterAndProjectVerticesNode(vertices, vertex.getVariable(), vertexPredicates, projectionKeys);
            planTable.add(new PlanTableEntry(PlanTableEntry.Type.VERTEX, Sets.newHashSet((Object[])new String[]{vertexVariable}), allPredicates, new QueryPlanEstimator(new QueryPlan(node), this.queryHandler, this.graphStatistics)));
        }
    }

    private void createEdgePlans(PlanTable planTable) {
        for (Edge edge : this.queryHandler.getEdges()) {
            String edgeVariable = edge.getVariable();
            String sourceVariable = this.queryHandler.getVertexById(edge.getSourceVertexId()).getVariable();
            String targetVariable = this.queryHandler.getVertexById(edge.getTargetVertexId()).getVariable();
            CNF allPredicates = this.queryHandler.getPredicates();
            CNF edgePredicates = allPredicates.removeSubCNF(edgeVariable);
            Set<String> projectionKeys = allPredicates.getPropertyKeys(edgeVariable);
            boolean isPath = edge.getUpperBound() != 1;
            DataSet edges = edge.getLabel().equals("") ? this.graph.getEdges() : this.graph.getEdgesByLabel(edge.getLabel());
            FilterAndProjectEdgesNode node = new FilterAndProjectEdgesNode(edges, sourceVariable, edgeVariable, targetVariable, edgePredicates, projectionKeys, isPath);
            PlanTableEntry.Type type = edge.hasVariableLength() ? PlanTableEntry.Type.PATH : PlanTableEntry.Type.EDGE;
            planTable.add(new PlanTableEntry(type, Sets.newHashSet((Object[])new String[]{edgeVariable}), allPredicates, new QueryPlanEstimator(new QueryPlan(node), this.queryHandler, this.graphStatistics)));
        }
    }

    private PlanTable evaluateJoins(PlanTable currentTable) {
        PlanTable newTable = new PlanTable();
        for (int i = 0; i < currentTable.size(); ++i) {
            PlanTableEntry leftEntry = currentTable.get(i);
            if (!this.mayExtend(leftEntry)) continue;
            for (int j = 0; j < currentTable.size(); ++j) {
                List<String> joinVariables;
                PlanTableEntry rightEntry = currentTable.get(j);
                if (i == j || (joinVariables = this.getOverlap(leftEntry, rightEntry)).size() <= 0) continue;
                if (rightEntry.getType() == PlanTableEntry.Type.PATH && joinVariables.size() == 2) {
                    newTable.add(this.joinEntries(leftEntry, rightEntry, joinVariables.subList(0, 1)));
                    newTable.add(this.joinEntries(leftEntry, rightEntry, joinVariables.subList(1, 2)));
                    continue;
                }
                newTable.add(this.joinEntries(leftEntry, rightEntry, joinVariables));
            }
        }
        return newTable;
    }

    private boolean mayExtend(PlanTableEntry entry) {
        return entry.getType() == PlanTableEntry.Type.VERTEX || entry.getType() == PlanTableEntry.Type.GRAPH;
    }

    private List<String> getOverlap(PlanTableEntry firstEntry, PlanTableEntry secondEntry) {
        Set<String> overlap = firstEntry.getAllVariables();
        overlap.retainAll(secondEntry.getAllVariables());
        return new ArrayList<String>(overlap);
    }

    private PlanTableEntry joinEntries(PlanTableEntry leftEntry, PlanTableEntry rightEntry, List<String> joinVariables) {
        BinaryNode node;
        if (rightEntry.getType() == PlanTableEntry.Type.PATH) {
            assert (joinVariables.size() == 1);
            node = this.createExpandNode(leftEntry, rightEntry, joinVariables.get(0));
        } else {
            node = new JoinEmbeddingsNode(leftEntry.getQueryPlan().getRoot(), rightEntry.getQueryPlan().getRoot(), joinVariables, this.vertexStrategy, this.edgeStrategy);
        }
        HashSet processedVariables = Sets.newHashSet(leftEntry.getProcessedVariables());
        processedVariables.addAll(rightEntry.getProcessedVariables());
        CNF predicates = this.mergePredicates(leftEntry, rightEntry);
        return new PlanTableEntry(PlanTableEntry.Type.GRAPH, processedVariables, predicates, new QueryPlanEstimator(new QueryPlan(node), this.queryHandler, this.graphStatistics));
    }

    private ExpandEmbeddingsNode createExpandNode(PlanTableEntry leftEntry, PlanTableEntry rightEntry, String startVariable) {
        String pathVariable = rightEntry.getQueryPlan().getRoot().getEmbeddingMetaData().getEdgeVariables().get(0);
        Edge queryEdge = this.queryHandler.getEdgeByVariable(pathVariable);
        Vertex sourceVertex = this.queryHandler.getVertexById(queryEdge.getSourceVertexId());
        Vertex targetVertex = this.queryHandler.getVertexById(queryEdge.getTargetVertexId());
        int lowerBound = queryEdge.getLowerBound();
        int upperBound = queryEdge.getUpperBound();
        ExpandDirection direction = sourceVertex.getVariable().equals(startVariable) ? ExpandDirection.OUT : ExpandDirection.IN;
        String endVariable = direction == ExpandDirection.OUT ? targetVertex.getVariable() : sourceVertex.getVariable();
        return new ExpandEmbeddingsNode(leftEntry.getQueryPlan().getRoot(), rightEntry.getQueryPlan().getRoot(), startVariable, pathVariable, endVariable, lowerBound, upperBound, direction, this.vertexStrategy, this.edgeStrategy);
    }

    private PlanTable evaluateFilter(PlanTable currentTable) {
        PlanTable newTable = new PlanTable();
        for (PlanTableEntry entry : currentTable) {
            HashSet variables = Sets.newHashSet(entry.getProcessedVariables());
            CNF predicates = entry.getPredicates();
            CNF subCNF = predicates.removeSubCNF(variables);
            if (subCNF.size() > 0) {
                FilterEmbeddingsNode node = new FilterEmbeddingsNode(entry.getQueryPlan().getRoot(), subCNF);
                newTable.add(new PlanTableEntry(PlanTableEntry.Type.GRAPH, Sets.newHashSet(entry.getProcessedVariables()), predicates, new QueryPlanEstimator(new QueryPlan(node), this.queryHandler, this.graphStatistics)));
                continue;
            }
            newTable.add(entry);
        }
        return newTable;
    }

    private PlanTable evaluateProjection(PlanTable currentTable) {
        PlanTable newTable = new PlanTable();
        for (PlanTableEntry entry : currentTable) {
            Set<Pair<String, String>> propertyPairs = entry.getPropertyPairs();
            Set<Pair<String, String>> projectionPairs = entry.getProjectionPairs();
            Set updatedPropertyPairs = propertyPairs.stream().filter(projectionPairs::contains).collect(Collectors.toSet());
            if (updatedPropertyPairs.size() < propertyPairs.size()) {
                ProjectEmbeddingsNode node = new ProjectEmbeddingsNode(entry.getQueryPlan().getRoot(), new ArrayList<Pair<String, String>>(updatedPropertyPairs));
                newTable.add(new PlanTableEntry(PlanTableEntry.Type.GRAPH, Sets.newHashSet(entry.getProcessedVariables()), entry.getPredicates(), new QueryPlanEstimator(new QueryPlan(node), this.queryHandler, this.graphStatistics)));
                continue;
            }
            newTable.add(entry);
        }
        return newTable;
    }

    private PlanTable evaluateCartesianProducts(PlanTable currentTable) {
        PlanTable newTable = new PlanTable();
        for (int i = 0; i < currentTable.size(); ++i) {
            PlanTableEntry leftEntry = currentTable.get(i);
            for (int j = i + 1; j < currentTable.size(); ++j) {
                PlanTableEntry rightEntry = currentTable.get(j);
                CNF joinPredicate = this.getJoinPredicate(leftEntry, rightEntry);
                if (joinPredicate.size() > 0) {
                    newTable.add(this.createValueJoinEntry(leftEntry, rightEntry, joinPredicate));
                    continue;
                }
                newTable.add(this.createCartesianProductEntry(leftEntry, rightEntry));
            }
        }
        return newTable;
    }

    private CNF getJoinPredicate(PlanTableEntry leftEntry, PlanTableEntry rightEntry) {
        Set<String> allVariables = leftEntry.getAllVariables();
        allVariables.addAll(rightEntry.getAllVariables());
        CNF leftPredicates = new CNF(leftEntry.getPredicates());
        CNF rightPredicates = new CNF(rightEntry.getPredicates());
        leftPredicates.removeSubCNF(rightEntry.getProcessedVariables());
        rightPredicates.removeSubCNF(leftEntry.getProcessedVariables());
        CNF predicates = leftPredicates.and(rightPredicates).getSubCNF(allVariables);
        return new CNF(predicates.getPredicates().stream().filter(p -> p.size() == 1 && ((ComparisonExpression)p.getPredicates().get(0)).getComparator().equals((Object)Comparator.EQ)).collect(Collectors.toList()));
    }

    private PlanTableEntry createCartesianProductEntry(PlanTableEntry leftEntry, PlanTableEntry rightEntry) {
        CartesianProductNode node = new CartesianProductNode(leftEntry.getQueryPlan().getRoot(), rightEntry.getQueryPlan().getRoot(), this.vertexStrategy, this.edgeStrategy);
        Set<String> processedVariables = leftEntry.getProcessedVariables();
        processedVariables.addAll(rightEntry.getProcessedVariables());
        CNF predicates = this.mergePredicates(leftEntry, rightEntry);
        return new PlanTableEntry(PlanTableEntry.Type.GRAPH, processedVariables, predicates, new QueryPlanEstimator(new QueryPlan(node), this.queryHandler, this.graphStatistics));
    }

    private PlanTableEntry createValueJoinEntry(PlanTableEntry leftEntry, PlanTableEntry rightEntry, CNF joinPredicate) {
        ArrayList<Pair<String, String>> leftProperties = new ArrayList<Pair<String, String>>();
        ArrayList<Pair<String, String>> rightProperties = new ArrayList<Pair<String, String>>();
        for (CNFElement e : joinPredicate.getPredicates()) {
            ComparisonExpression comparison = (ComparisonExpression)e.getPredicates().get(0);
            Pair<String, String> joinProperty = this.extractJoinProperty(comparison.getLhs());
            if (leftEntry.getAllVariables().contains(joinProperty.getKey())) {
                leftProperties.add(joinProperty);
            } else {
                rightProperties.add(joinProperty);
            }
            joinProperty = this.extractJoinProperty(comparison.getRhs());
            if (leftEntry.getAllVariables().contains(joinProperty.getKey())) {
                leftProperties.add(joinProperty);
                continue;
            }
            rightProperties.add(joinProperty);
        }
        ValueJoinNode node = new ValueJoinNode(leftEntry.getQueryPlan().getRoot(), rightEntry.getQueryPlan().getRoot(), leftProperties, rightProperties, this.vertexStrategy, this.edgeStrategy);
        Set<String> processedVariables = leftEntry.getProcessedVariables();
        processedVariables.addAll(rightEntry.getProcessedVariables());
        CNF predicates = this.mergePredicates(leftEntry, rightEntry);
        return new PlanTableEntry(PlanTableEntry.Type.GRAPH, processedVariables, predicates, new QueryPlanEstimator(new QueryPlan(node), this.queryHandler, this.graphStatistics));
    }

    private Pair<String, String> extractJoinProperty(QueryComparable comparable) {
        if (comparable instanceof PropertySelectorComparable) {
            PropertySelectorComparable propertySelector = (PropertySelectorComparable)comparable;
            return Pair.of((Object)propertySelector.getVariable(), (Object)propertySelector.getPropertyKey());
        }
        throw new RuntimeException("Comparable " + comparable + "cant be used for ValueJoin");
    }

    private CNF mergePredicates(PlanTableEntry leftEntry, PlanTableEntry rightEntry) {
        CNF leftPredicates = new CNF(leftEntry.getPredicates());
        CNF rightPredicates = new CNF(rightEntry.getPredicates());
        leftPredicates.removeSubCNF(rightEntry.getProcessedVariables());
        rightPredicates.removeSubCNF(leftEntry.getProcessedVariables());
        return leftPredicates.and(rightPredicates);
    }
}

