/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.plantable;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.estimation.QueryPlanEstimator;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.QueryPlan;

public class PlanTableEntry {
    private final Type type;
    private final Set<String> processedVars;
    private final CNF predicates;
    private QueryPlanEstimator estimator;
    private long estimatedCardinality = -1L;

    public PlanTableEntry(Type type, Set<String> processedVars, CNF predicates, QueryPlanEstimator estimator) {
        this.type = type;
        this.processedVars = processedVars;
        this.predicates = predicates;
        this.estimator = estimator;
    }

    public Type getType() {
        return this.type;
    }

    public CNF getPredicates() {
        return this.predicates;
    }

    public Set<String> getAllVariables() {
        return new HashSet<String>(this.estimator.getQueryPlan().getRoot().getEmbeddingMetaData().getVariables());
    }

    public Set<String> getAttributedVariables() {
        return new HashSet<String>(this.estimator.getQueryPlan().getRoot().getEmbeddingMetaData().getVariablesWithProperties());
    }

    public Set<String> getProcessedVariables() {
        return this.processedVars;
    }

    public Set<Pair<String, String>> getPropertyPairs() {
        return this.getAttributedVariables().stream().flatMap(var -> this.getQueryPlan().getRoot().getEmbeddingMetaData().getPropertyKeys((String)var).stream().map(key -> Pair.of((Object)var, (Object)key))).collect(Collectors.toSet());
    }

    public Set<Pair<String, String>> getProjectionPairs() {
        return this.predicates.getVariables().stream().flatMap(var -> this.predicates.getPropertyKeys((String)var).stream().map(key -> Pair.of((Object)var, (Object)key))).collect(Collectors.toSet());
    }

    public long getEstimatedCardinality() {
        if (this.estimatedCardinality == -1L) {
            this.estimatedCardinality = this.estimator.getCardinality();
        }
        return this.estimatedCardinality;
    }

    public QueryPlan getQueryPlan() {
        return this.estimator.getQueryPlan();
    }

    public String toString() {
        return String.format("PlanTableEntry | type: %s | all-vars: %s | proc-vars: %s | attr-vars: %s | est-card: %d | prediates: %s | Plan :%n%s", new Object[]{this.type, this.getAllVariables(), this.getProcessedVariables(), this.getAttributedVariables(), this.estimatedCardinality, this.predicates, this.estimator.getQueryPlan()});
    }

    public static enum Type {
        VERTEX,
        EDGE,
        PATH,
        GRAPH;

    }
}

