/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan;

import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.PlanNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.UnaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;

public class QueryPlan {
    private static final String PAD_STRING = "|.";
    private final PlanNode root;

    public QueryPlan(PlanNode root) {
        this.root = root;
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public DataSet<Embedding> execute() {
        return this.root.execute();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printPlanNode(this.root, 0, sb);
        return sb.toString();
    }

    private void printPlanNode(PlanNode node, int level, StringBuilder sb) {
        sb.append(String.format("%s|-%s%n", StringUtils.leftPad((String)"", (int)(level * 2), (String)PAD_STRING), node));
        ++level;
        if (node instanceof UnaryNode) {
            this.printPlanNode(((UnaryNode)node).getChildNode(), level, sb);
        } else if (node instanceof BinaryNode) {
            this.printPlanNode(((BinaryNode)node).getLeftChild(), level, sb);
            this.printPlanNode(((BinaryNode)node).getRightChild(), level, sb);
        }
    }
}

