/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.operators.base.CrossOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.CartesianProduct;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.JoinNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.PlanNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class CartesianProductNode
extends BinaryNode
implements JoinNode {
    private final MatchStrategy vertexStrategy;
    private final MatchStrategy edgeStrategy;
    private final CrossOperatorBase.CrossHint crossHint;

    public CartesianProductNode(PlanNode leftChild, PlanNode rightChild, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy) {
        this(leftChild, rightChild, vertexStrategy, edgeStrategy, CrossOperatorBase.CrossHint.OPTIMIZER_CHOOSES);
    }

    public CartesianProductNode(PlanNode leftChild, PlanNode rightChild, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy, CrossOperatorBase.CrossHint crossHint) {
        super(leftChild, rightChild);
        this.vertexStrategy = vertexStrategy;
        this.edgeStrategy = edgeStrategy;
        this.crossHint = crossHint;
    }

    @Override
    public DataSet<Embedding> execute() {
        CartesianProduct op = new CartesianProduct(this.getLeftChild().execute(), this.getRightChild().execute(), this.getRightChild().getEmbeddingMetaData().getEntryCount(), this.getDistinctVertexColumnsLeft(), this.getDistinctVertexColumnsRight(), this.getDistinctEdgeColumnsLeft(), this.getDistinctEdgeColumnsRight(), this.crossHint);
        op.setName(this.toString());
        return op.evaluate();
    }

    @Override
    protected EmbeddingMetaData computeEmbeddingMetaData() {
        EmbeddingMetaData leftInputMetaData = this.getLeftChild().getEmbeddingMetaData();
        EmbeddingMetaData rightInputMetaData = this.getRightChild().getEmbeddingMetaData();
        EmbeddingMetaData embeddingMetaData = new EmbeddingMetaData(leftInputMetaData);
        int entryCount = leftInputMetaData.getEntryCount();
        for (String var : rightInputMetaData.getVariables()) {
            embeddingMetaData.setEntryColumn(var, rightInputMetaData.getEntryType(var), entryCount++);
        }
        int propertyCount = leftInputMetaData.getPropertyCount();
        for (String var : rightInputMetaData.getVariables()) {
            for (String key : rightInputMetaData.getPropertyKeys(var)) {
                embeddingMetaData.setPropertyColumn(var, key, propertyCount++);
            }
        }
        return embeddingMetaData;
    }

    private List<Integer> getDistinctVertexColumnsLeft() {
        return this.getDistinctVertexColumns(this.getLeftChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctVertexColumnsRight() {
        return this.getDistinctVertexColumns(this.getRightChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctVertexColumns(EmbeddingMetaData metaData) {
        return this.vertexStrategy == MatchStrategy.ISOMORPHISM ? metaData.getVertexVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Integer> getDistinctEdgeColumnsLeft() {
        return this.getDistinctEdgeColumns(this.getLeftChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctEdgeColumnsRight() {
        return this.getDistinctEdgeColumns(this.getRightChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctEdgeColumns(EmbeddingMetaData metaData) {
        return this.edgeStrategy == MatchStrategy.ISOMORPHISM ? metaData.getEdgeVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    public String toString() {
        return String.format("CartesianProductNode{vertexMorphismType=%s, edgeMorphismType=%s}", new Object[]{this.vertexStrategy, this.edgeStrategy});
    }
}

