/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.expand.ExpandEmbeddingsBulk;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.JoinNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.PlanNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.utils.ExpandDirection;

public class ExpandEmbeddingsNode
extends BinaryNode
implements JoinNode {
    private final int expandColumn;
    private final String startVariable;
    private final String pathVariable;
    private final String endVariable;
    private final int lowerBound;
    private final int upperBound;
    private final int closingColumn;
    private final ExpandDirection expandDirection;
    private final MatchStrategy vertexStrategy;
    private final MatchStrategy edgeStrategy;

    public ExpandEmbeddingsNode(PlanNode leftChild, PlanNode rightChild, String startVariable, String pathVariable, String endVariable, int lowerBound, int upperBound, ExpandDirection expandDirection, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy) {
        super(leftChild, rightChild);
        this.pathVariable = pathVariable;
        this.startVariable = startVariable;
        this.endVariable = endVariable;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound == 0 ? Integer.MAX_VALUE : upperBound;
        this.expandDirection = expandDirection;
        this.vertexStrategy = vertexStrategy;
        this.edgeStrategy = edgeStrategy;
        this.expandColumn = leftChild.getEmbeddingMetaData().getEntryColumn(startVariable);
        this.closingColumn = leftChild.getEmbeddingMetaData().containsEntryColumn(endVariable) ? leftChild.getEmbeddingMetaData().getEntryColumn(endVariable) : -1;
    }

    @Override
    public DataSet<Embedding> execute() {
        ExpandEmbeddingsBulk op = new ExpandEmbeddingsBulk(this.getLeftChild().execute(), this.getRightChild().execute(), this.expandColumn, this.lowerBound, this.upperBound, this.expandDirection, this.getDistinctVertexColumns(this.getLeftChild().getEmbeddingMetaData()), this.getDistinctEdgeColumns(this.getLeftChild().getEmbeddingMetaData()), this.closingColumn, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
        op.setName(this.toString());
        return op.evaluate();
    }

    @Override
    protected EmbeddingMetaData computeEmbeddingMetaData() {
        EmbeddingMetaData inputMetaData = this.getLeftChild().getEmbeddingMetaData();
        EmbeddingMetaData metaData = new EmbeddingMetaData(inputMetaData);
        metaData.setEntryColumn(this.pathVariable, EmbeddingMetaData.EntryType.PATH, inputMetaData.getEntryCount());
        metaData.setDirection(this.pathVariable, this.expandDirection);
        if (!inputMetaData.containsEntryColumn(this.endVariable)) {
            metaData.setEntryColumn(this.endVariable, EmbeddingMetaData.EntryType.VERTEX, inputMetaData.getEntryCount() + 1);
        }
        return metaData;
    }

    private List<Integer> getDistinctVertexColumns(EmbeddingMetaData metaData) {
        return this.vertexStrategy == MatchStrategy.ISOMORPHISM ? metaData.getVertexVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Integer> getDistinctEdgeColumns(EmbeddingMetaData metaData) {
        return this.edgeStrategy == MatchStrategy.ISOMORPHISM ? metaData.getEdgeVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    public String toString() {
        return String.format("ExpandEmbeddingsNode={startVariable='%s', pathVariable='%s', endVariable='%s', lowerBound=%d, upperBound=%d, expandDirection=%s, vertexMorphismType=%s, edgeMorphismType=%s}", new Object[]{this.startVariable, this.pathVariable, this.endVariable, this.lowerBound, this.upperBound, this.expandDirection, this.vertexStrategy, this.edgeStrategy});
    }
}

