/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.JoinEmbeddings;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.JoinNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.PlanNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class JoinEmbeddingsNode
extends BinaryNode
implements JoinNode {
    private final List<String> joinVariables;
    private final MatchStrategy vertexStrategy;
    private final MatchStrategy edgeStrategy;
    private final JoinOperatorBase.JoinHint joinHint;

    public JoinEmbeddingsNode(PlanNode leftChild, PlanNode rightChild, List<String> joinVariables, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy) {
        this(leftChild, rightChild, joinVariables, vertexStrategy, edgeStrategy, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
    }

    public JoinEmbeddingsNode(PlanNode leftChild, PlanNode rightChild, List<String> joinVariables, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy, JoinOperatorBase.JoinHint joinHint) {
        super(leftChild, rightChild);
        this.joinVariables = joinVariables;
        this.vertexStrategy = vertexStrategy;
        this.edgeStrategy = edgeStrategy;
        this.joinHint = joinHint;
    }

    @Override
    public DataSet<Embedding> execute() {
        JoinEmbeddings op = new JoinEmbeddings(this.getLeftChild().execute(), this.getRightChild().execute(), this.getRightChild().getEmbeddingMetaData().getEntryCount(), this.getJoinColumnsLeft(), this.getJoinColumnsRight(), this.getDistinctVertexColumnsLeft(), this.getDistinctVertexColumnsRight(), this.getDistinctEdgeColumnsLeft(), this.getDistinctEdgeColumnsRight(), this.joinHint);
        op.setName(this.toString());
        return op.evaluate();
    }

    @Override
    protected EmbeddingMetaData computeEmbeddingMetaData() {
        EmbeddingMetaData leftInputMetaData = this.getLeftChild().getEmbeddingMetaData();
        EmbeddingMetaData rightInputMetaData = this.getRightChild().getEmbeddingMetaData();
        EmbeddingMetaData embeddingMetaData = new EmbeddingMetaData(leftInputMetaData);
        int entryCount = leftInputMetaData.getEntryCount();
        for (String var : rightInputMetaData.getVariables()) {
            if (!this.joinVariables.contains(var)) {
                embeddingMetaData.setEntryColumn(var, rightInputMetaData.getEntryType(var), entryCount++);
            }
            if (rightInputMetaData.getEntryType(var) != EmbeddingMetaData.EntryType.PATH) continue;
            embeddingMetaData.setDirection(var, rightInputMetaData.getDirection(var));
        }
        int propertyCount = leftInputMetaData.getPropertyCount();
        for (String var : rightInputMetaData.getVariables()) {
            for (String key : rightInputMetaData.getPropertyKeys(var)) {
                embeddingMetaData.setPropertyColumn(var, key, propertyCount++);
            }
        }
        return embeddingMetaData;
    }

    private List<Integer> getJoinColumnsLeft() {
        return this.joinVariables.stream().map(var -> this.getLeftChild().getEmbeddingMetaData().getEntryColumn((String)var)).collect(Collectors.toList());
    }

    private List<Integer> getJoinColumnsRight() {
        return this.joinVariables.stream().map(var -> this.getRightChild().getEmbeddingMetaData().getEntryColumn((String)var)).collect(Collectors.toList());
    }

    private List<Integer> getDistinctVertexColumnsLeft() {
        EmbeddingMetaData metaData = this.getLeftChild().getEmbeddingMetaData();
        return this.vertexStrategy == MatchStrategy.ISOMORPHISM ? metaData.getVertexVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Integer> getDistinctVertexColumnsRight() {
        EmbeddingMetaData metaData = this.getRightChild().getEmbeddingMetaData();
        return this.vertexStrategy == MatchStrategy.ISOMORPHISM ? metaData.getVertexVariables().stream().filter(var -> !this.joinVariables.contains(var)).map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Integer> getDistinctEdgeColumnsLeft() {
        return this.getDistinctEdgeColumns(this.getLeftChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctEdgeColumnsRight() {
        return this.getDistinctEdgeColumns(this.getRightChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctEdgeColumns(EmbeddingMetaData metaData) {
        return this.edgeStrategy == MatchStrategy.ISOMORPHISM ? metaData.getEdgeVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    public String toString() {
        return String.format("JoinEmbeddingsNode{joinVariables=%s, vertexMorphismType=%s, edgeMorphismType=%s}", new Object[]{this.joinVariables, this.vertexStrategy, this.edgeStrategy});
    }
}

