/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.binary;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.join.ValueJoin;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.BinaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.JoinNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.PlanNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class ValueJoinNode
extends BinaryNode
implements JoinNode {
    private final List<Pair<String, String>> leftJoinProperties;
    private final List<Pair<String, String>> rightJoinProperties;
    private final MatchStrategy vertexStrategy;
    private final MatchStrategy edgeStrategy;
    private final JoinOperatorBase.JoinHint joinHint;

    public ValueJoinNode(PlanNode leftChild, PlanNode rightChild, List<Pair<String, String>> leftJoinProperties, List<Pair<String, String>> rightJoinProperties, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy) {
        this(leftChild, rightChild, leftJoinProperties, rightJoinProperties, vertexStrategy, edgeStrategy, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES);
    }

    public ValueJoinNode(PlanNode leftChild, PlanNode rightChild, List<Pair<String, String>> leftJoinProperties, List<Pair<String, String>> rightJoinProperties, MatchStrategy vertexStrategy, MatchStrategy edgeStrategy, JoinOperatorBase.JoinHint joinHint) {
        super(leftChild, rightChild);
        this.leftJoinProperties = leftJoinProperties;
        this.rightJoinProperties = rightJoinProperties;
        this.vertexStrategy = vertexStrategy;
        this.edgeStrategy = edgeStrategy;
        this.joinHint = joinHint;
    }

    @Override
    public DataSet<Embedding> execute() {
        ValueJoin op = new ValueJoin(this.getLeftChild().execute(), this.getRightChild().execute(), this.getJoinPropertiesLeft(), this.getJoinPropertiesRight(), this.getRightChild().getEmbeddingMetaData().getEntryCount(), this.getDistinctVertexColumnsLeft(), this.getDistinctVertexColumnsRight(), this.getDistinctEdgeColumnsLeft(), this.getDistinctEdgeColumnsRight(), this.joinHint);
        op.setName(this.toString());
        return op.evaluate();
    }

    @Override
    protected EmbeddingMetaData computeEmbeddingMetaData() {
        EmbeddingMetaData leftInputMetaData = this.getLeftChild().getEmbeddingMetaData();
        EmbeddingMetaData rightInputMetaData = this.getRightChild().getEmbeddingMetaData();
        EmbeddingMetaData embeddingMetaData = new EmbeddingMetaData(leftInputMetaData);
        int entryCount = leftInputMetaData.getEntryCount();
        for (String var : rightInputMetaData.getVariables()) {
            embeddingMetaData.setEntryColumn(var, rightInputMetaData.getEntryType(var), entryCount++);
        }
        int propertyCount = leftInputMetaData.getPropertyCount();
        for (String var : rightInputMetaData.getVariables()) {
            for (String key : rightInputMetaData.getPropertyKeys(var)) {
                embeddingMetaData.setPropertyColumn(var, key, propertyCount++);
            }
        }
        return embeddingMetaData;
    }

    private List<Integer> getJoinPropertiesLeft() {
        return this.leftJoinProperties.stream().map(p -> this.getLeftChild().getEmbeddingMetaData().getPropertyColumn((String)p.getKey(), (String)p.getValue())).collect(Collectors.toList());
    }

    private List<Integer> getJoinPropertiesRight() {
        return this.rightJoinProperties.stream().map(p -> this.getRightChild().getEmbeddingMetaData().getPropertyColumn((String)p.getKey(), (String)p.getValue())).collect(Collectors.toList());
    }

    private List<Integer> getDistinctVertexColumnsLeft() {
        return this.getDistinctVertexColumns(this.getLeftChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctVertexColumnsRight() {
        return this.getDistinctVertexColumns(this.getRightChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctVertexColumns(EmbeddingMetaData metaData) {
        return this.vertexStrategy == MatchStrategy.ISOMORPHISM ? metaData.getVertexVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    private List<Integer> getDistinctEdgeColumnsLeft() {
        return this.getDistinctEdgeColumns(this.getLeftChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctEdgeColumnsRight() {
        return this.getDistinctEdgeColumns(this.getRightChild().getEmbeddingMetaData());
    }

    private List<Integer> getDistinctEdgeColumns(EmbeddingMetaData metaData) {
        return this.edgeStrategy == MatchStrategy.ISOMORPHISM ? metaData.getEdgeVariables().stream().map(metaData::getEntryColumn).collect(Collectors.toList()) : Collections.emptyList();
    }

    public String toString() {
        return String.format("ValueJoinNode{leftJoinProperties=%s, rightJoinProperties=%s, vertexMorphismType=%s, edgeMorphismType=%s}", new Object[]{this.leftJoinProperties, this.rightJoinProperties, this.vertexStrategy, this.edgeStrategy});
    }
}

