/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.leaf;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.filter.FilterAndProjectEdges;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.FilterNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.LeafNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.ProjectionNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class FilterAndProjectEdgesNode<E extends Edge>
extends LeafNode
implements FilterNode,
ProjectionNode {
    private DataSet<E> edges;
    private final String sourceVariable;
    private final String edgeVariable;
    private final String targetVariable;
    private CNF filterPredicate;
    private final List<String> projectionKeys;
    private final boolean isPath;

    public FilterAndProjectEdgesNode(DataSet<E> edges, String sourceVariable, String edgeVariable, String targetVariable, CNF filterPredicate, Set<String> projectionKeys, boolean isPath) {
        this.edges = edges;
        this.sourceVariable = sourceVariable;
        this.edgeVariable = edgeVariable;
        this.targetVariable = targetVariable;
        this.filterPredicate = filterPredicate;
        this.projectionKeys = new ArrayList<String>(projectionKeys);
        this.isPath = isPath;
    }

    @Override
    public DataSet<Embedding> execute() {
        FilterAndProjectEdges<E> op = new FilterAndProjectEdges<E>(this.edges, this.filterPredicate, this.projectionKeys, this.isLoop());
        op.setName(this.toString());
        return op.evaluate();
    }

    public CNF getFilterPredicate() {
        return new CNF(this.filterPredicate);
    }

    public List<String> getProjectionKeys() {
        return new ArrayList<String>(this.projectionKeys);
    }

    public boolean isLoop() {
        return this.sourceVariable.equals(this.targetVariable) && !this.isPath;
    }

    @Override
    protected EmbeddingMetaData computeEmbeddingMetaData() {
        EmbeddingMetaData embeddingMetaData = new EmbeddingMetaData();
        embeddingMetaData.setEntryColumn(this.sourceVariable, EmbeddingMetaData.EntryType.VERTEX, 0);
        embeddingMetaData.setEntryColumn(this.edgeVariable, EmbeddingMetaData.EntryType.EDGE, 1);
        if (!this.isLoop()) {
            embeddingMetaData.setEntryColumn(this.targetVariable, EmbeddingMetaData.EntryType.VERTEX, 2);
        }
        embeddingMetaData = this.setPropertyColumns(embeddingMetaData, this.edgeVariable, this.projectionKeys);
        return embeddingMetaData;
    }

    public String toString() {
        return String.format("FilterAndProjectEdgesNode{sourceVariable='%s', edgeVariable='%s', targetVariable='%s', filterPredicate=%s, projectionKeys=%s}", this.sourceVariable, this.edgeVariable, this.targetVariable, this.filterPredicate, this.projectionKeys);
    }
}

