/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.leaf;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.java.DataSet;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.impl.operators.matching.common.query.predicates.CNF;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.filter.FilterAndProjectVertices;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.FilterNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.LeafNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.ProjectionNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class FilterAndProjectVerticesNode<V extends Vertex>
extends LeafNode
implements FilterNode,
ProjectionNode {
    private DataSet<V> vertices;
    private final String vertexVariable;
    private CNF filterPredicate;
    private final List<String> projectionKeys;

    public FilterAndProjectVerticesNode(DataSet<V> vertices, String vertexVariable, CNF filterPredicate, Set<String> projectionKeys) {
        this.vertices = vertices;
        this.vertexVariable = vertexVariable;
        this.filterPredicate = filterPredicate;
        this.projectionKeys = new ArrayList<String>(projectionKeys);
    }

    @Override
    public DataSet<Embedding> execute() {
        FilterAndProjectVertices<V> op = new FilterAndProjectVertices<V>(this.vertices, this.filterPredicate, this.projectionKeys);
        op.setName(this.toString());
        return op.evaluate();
    }

    public CNF getFilterPredicate() {
        return new CNF(this.filterPredicate);
    }

    public List<String> getProjectionKeys() {
        return new ArrayList<String>(this.projectionKeys);
    }

    @Override
    protected EmbeddingMetaData computeEmbeddingMetaData() {
        EmbeddingMetaData embeddingMetaData = new EmbeddingMetaData();
        embeddingMetaData.setEntryColumn(this.vertexVariable, EmbeddingMetaData.EntryType.VERTEX, 0);
        embeddingMetaData = this.setPropertyColumns(embeddingMetaData, this.vertexVariable, this.projectionKeys);
        return embeddingMetaData;
    }

    public String toString() {
        return String.format("FilterAndProjectVerticesNode{vertexVariable=%s, filterPredicate=%s, projectionKeys=%s}", this.vertexVariable, this.filterPredicate, this.projectionKeys);
    }
}

