/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.unary;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.flink.api.java.DataSet;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.operators.project.ProjectEmbeddings;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.PlanNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.ProjectionNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.planning.queryplan.UnaryNode;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.EmbeddingMetaData;

public class ProjectEmbeddingsNode
extends UnaryNode
implements ProjectionNode {
    private final List<Integer> whiteListColumns;
    private final List<Pair<String, String>> projectionKeys;

    public ProjectEmbeddingsNode(PlanNode childNode, List<Pair<String, String>> projectionKeys) {
        super(childNode);
        this.projectionKeys = projectionKeys;
        EmbeddingMetaData childMetaData = childNode.getEmbeddingMetaData();
        this.whiteListColumns = projectionKeys.stream().map(pair -> childMetaData.getPropertyColumn((String)pair.getLeft(), (String)pair.getRight())).collect(Collectors.toList());
    }

    @Override
    public DataSet<Embedding> execute() {
        ProjectEmbeddings op = new ProjectEmbeddings(this.getChildNode().execute(), this.whiteListColumns);
        op.setName(this.toString());
        return op.evaluate();
    }

    @Override
    protected EmbeddingMetaData computeEmbeddingMetaData() {
        EmbeddingMetaData childMetaData = this.getChildNode().getEmbeddingMetaData();
        this.projectionKeys.sort(Comparator.comparingInt(key -> childMetaData.getPropertyColumn((String)key.getLeft(), (String)key.getRight())));
        EmbeddingMetaData embeddingMetaData = new EmbeddingMetaData();
        childMetaData.getVariables().forEach(var -> embeddingMetaData.setEntryColumn((String)var, childMetaData.getEntryType((String)var), childMetaData.getEntryColumn((String)var)));
        IntStream.range(0, this.projectionKeys.size()).forEach(i -> embeddingMetaData.setPropertyColumn((String)this.projectionKeys.get(i).getLeft(), (String)this.projectionKeys.get(i).getRight(), i));
        return embeddingMetaData;
    }

    public String toString() {
        return String.format("ProjectEmbeddingsNode{projectionKeys=%s}", this.projectionKeys);
    }
}

