/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.Value;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.properties.PropertyValue;

public class Embedding
implements Value,
CopyableValue<Embedding> {
    public static final transient int ID_ENTRY_SIZE = 13;
    public static final transient byte ID_ENTRY_FLAG = 0;
    public static final transient byte ID_LIST_FLAG = 1;
    private static final long serialVersionUID = 1L;
    private byte[] idData;
    private byte[] propertyData;
    private byte[] idListData;

    public Embedding() {
        this(new byte[0], new byte[0], new byte[0]);
    }

    public Embedding(byte[] idData, byte[] propertyData, byte[] idListData) {
        this.idData = idData;
        this.propertyData = propertyData;
        this.idListData = idListData;
    }

    public void add(GradoopId id) {
        this.add(id, false);
    }

    public void addAll(GradoopId ... ids) {
        byte[] newIds = new byte[this.idData.length + ids.length * 13];
        System.arraycopy(this.idData, 0, newIds, 0, this.idData.length);
        int offset = this.idData.length;
        for (GradoopId id : ids) {
            newIds[offset] = 0;
            System.arraycopy(id.toByteArray(), 0, newIds, offset + 1, 12);
            offset += 13;
        }
        this.idData = newIds;
    }

    public GradoopId getId(int column) {
        return GradoopId.fromByteArray((byte[])this.getRawId(column));
    }

    public byte[] getRawId(int column) {
        byte[] rawEntry = this.getRawIdEntry(column);
        if (rawEntry[0] == 1) {
            throw new UnsupportedOperationException("Can't return ID for ID List");
        }
        return ArrayUtils.subarray((byte[])rawEntry, (int)1, (int)13);
    }

    public byte[] getRawIdEntry(int column) {
        int offset = this.getIdOffset(column);
        return ArrayUtils.subarray((byte[])this.idData, (int)offset, (int)(offset + 13));
    }

    public List<GradoopId> getIdAsList(int column) {
        int offset = this.getIdOffset(column);
        return this.idData[offset] == 1 ? this.getIdList(column) : Lists.newArrayList((Object[])new GradoopId[]{this.getId(column)});
    }

    public List<GradoopId> getIdsAsList(List<Integer> columns) {
        ArrayList<GradoopId> ids = new ArrayList<GradoopId>();
        for (Integer column : columns) {
            int offset = this.getIdOffset(column);
            if (this.idData[offset] == 1) {
                ids.addAll(this.getIdList(column));
                continue;
            }
            ids.add(this.getId(column));
        }
        return ids;
    }

    private void add(GradoopId id, boolean isIdList) {
        byte[] newIds = new byte[this.idData.length + 1 + 12];
        System.arraycopy(this.idData, 0, newIds, 0, this.idData.length);
        newIds[this.idData.length] = isIdList ? (byte)1 : 0;
        System.arraycopy(id.toByteArray(), 0, newIds, this.idData.length + 1, 12);
        this.idData = newIds;
    }

    private int getIdOffset(int column) {
        this.checkColumn(column);
        return column * 13;
    }

    public void add(GradoopId id, PropertyValue ... properties) {
        this.add(id);
        this.addPropertyValues(properties);
    }

    public void addPropertyValues(PropertyValue ... properties) {
        int newPropertiesSize = this.propertyData.length;
        for (PropertyValue property : properties) {
            newPropertiesSize += property.getByteSize() + 4;
        }
        byte[] newPropertyData = new byte[newPropertiesSize];
        System.arraycopy(this.propertyData, 0, newPropertyData, 0, this.propertyData.length);
        int offset = this.propertyData.length;
        for (PropertyValue property : properties) {
            this.writeProperty(property, newPropertyData, offset);
            offset += property.getByteSize() + 4;
        }
        this.propertyData = newPropertyData;
    }

    public PropertyValue getProperty(int column) {
        int offset = this.getPropertyOffset(column);
        int entryLength = Ints.fromByteArray((byte[])ArrayUtils.subarray((byte[])this.propertyData, (int)offset, (int)(offset + 4)));
        return PropertyValue.fromRawBytes((byte[])ArrayUtils.subarray((byte[])this.propertyData, (int)(offset += 4), (int)(offset + entryLength)));
    }

    public byte[] getRawProperty(int column) {
        int offset = this.getPropertyOffset(column);
        int entryLength = Ints.fromByteArray((byte[])ArrayUtils.subarray((byte[])this.propertyData, (int)offset, (int)(offset + 4)));
        return ArrayUtils.subarray((byte[])this.propertyData, (int)offset, (int)(offset + 4 + entryLength));
    }

    public List<PropertyValue> getProperties() {
        int entrySize;
        ArrayList<PropertyValue> properties = new ArrayList<PropertyValue>();
        for (int offset = 0; offset < this.propertyData.length; offset += entrySize) {
            entrySize = Ints.fromByteArray((byte[])ArrayUtils.subarray((byte[])this.propertyData, (int)offset, (int)(offset + 4)));
            properties.add(PropertyValue.fromRawBytes((byte[])ArrayUtils.subarray((byte[])this.propertyData, (int)(offset += 4), (int)(offset + entrySize))));
        }
        return properties;
    }

    private int getPropertyOffset(int column) {
        int offset;
        int entryLength;
        int i = 0;
        for (offset = 0; i < column && offset < this.propertyData.length; offset += entryLength + 4, ++i) {
            entryLength = Ints.fromByteArray((byte[])ArrayUtils.subarray((byte[])this.propertyData, (int)offset, (int)(offset + 4)));
        }
        if (offset >= this.propertyData.length) {
            throw new IndexOutOfBoundsException("Cant find Property. " + (i - 1) + " < " + column);
        }
        return offset;
    }

    public void add(GradoopId ... ids) {
        GradoopId pointer = GradoopId.get();
        this.add(pointer, true);
        byte[] newIdLists = new byte[this.idListData.length + 12 + 4 + ids.length * 12];
        System.arraycopy(this.idListData, 0, newIdLists, 0, this.idListData.length);
        this.writeId(pointer, newIdLists, this.idListData.length);
        this.writeInt(ids.length, newIdLists, this.idListData.length + 12);
        int offset = this.idListData.length + 12 + 4;
        for (GradoopId id : ids) {
            this.writeId(id, newIdLists, offset);
            offset += 12;
        }
        this.idListData = newIdLists;
    }

    public List<GradoopId> getIdList(int column) {
        int offset = this.getIdListOffset(column);
        int listSize = Ints.fromByteArray((byte[])ArrayUtils.subarray((byte[])this.idListData, (int)offset, (int)(offset + 4)));
        offset += 4;
        ArrayList<GradoopId> idList = new ArrayList<GradoopId>(listSize);
        for (int i = 0; i < listSize; ++i) {
            idList.add(GradoopId.fromByteArray((byte[])ArrayUtils.subarray((byte[])this.idListData, (int)offset, (int)(offset + 12))));
            offset += 12;
        }
        return idList;
    }

    private int getIdListOffset(int column) {
        int pointerOffset = this.getIdOffset(column);
        if (this.idData[pointerOffset++] != 1) {
            throw new UnsupportedOperationException("Entry is not an IDList");
        }
        byte[] pointer = ArrayUtils.subarray((byte[])this.idData, (int)pointerOffset, (int)(pointerOffset + 12));
        int offset = 0;
        boolean found = false;
        while (!found && offset < this.idListData.length) {
            byte[] comparePointer = ArrayUtils.subarray((byte[])this.idListData, (int)offset, (int)(offset + 12));
            offset += 12;
            found = Arrays.equals(pointer, comparePointer);
            if (found) continue;
            int listSize = Ints.fromByteArray((byte[])ArrayUtils.subarray((byte[])this.idListData, (int)offset, (int)(offset + 4)));
            offset += 12 * listSize + 4;
        }
        if (!found) {
            throw new RuntimeException("Could not find IdList entry");
        }
        return offset;
    }

    public int size() {
        return this.idData.length / 13;
    }

    public byte[] getIdData() {
        return this.idData;
    }

    public void setIdData(byte[] idData) {
        this.idData = idData;
    }

    public byte[] getPropertyData() {
        return this.propertyData;
    }

    public void setPropertyData(byte[] propertyData) {
        this.propertyData = propertyData;
    }

    public byte[] getIdListData() {
        return this.idListData;
    }

    public void setIdListData(byte[] idListData) {
        this.idListData = idListData;
    }

    public Embedding project(List<Integer> propertyWhiteList) {
        byte[] newPropertyData = new byte[]{};
        for (int index : propertyWhiteList) {
            newPropertyData = ArrayUtils.addAll((byte[])newPropertyData, (byte[])this.getRawProperty(index));
        }
        return new Embedding(this.idData, newPropertyData, this.idListData);
    }

    public Embedding reverse() {
        byte[] newIdData = new byte[this.idData.length];
        for (int i = this.size() - 1; i >= 0; --i) {
            System.arraycopy(this.getRawIdEntry(i), 0, newIdData, (this.size() - 1 - i) * 13, 13);
        }
        return new Embedding(newIdData, this.propertyData, this.idListData);
    }

    private void checkColumn(int column) {
        if (column < 0) {
            throw new IndexOutOfBoundsException("Negative columns are not allowed");
        }
        if (column >= this.size()) {
            throw new IndexOutOfBoundsException(column + " >= " + this.size());
        }
    }

    private void writeInt(int value, byte[] target, int offset) {
        System.arraycopy(Ints.toByteArray((int)value), 0, target, offset, 4);
    }

    private void writeId(GradoopId value, byte[] target, int offset) {
        System.arraycopy(value.toByteArray(), 0, target, offset, 12);
    }

    private void writeProperty(PropertyValue value, byte[] target, int offset) {
        this.writeInt(value.getByteSize(), target, offset);
        System.arraycopy(value.getRawBytes(), 0, target, offset += 4, value.getByteSize());
    }

    public int getBinaryLength() {
        return -1;
    }

    public void copyTo(Embedding target) {
        target.idData = new byte[this.idData.length];
        target.propertyData = new byte[this.propertyData.length];
        target.idListData = new byte[this.idListData.length];
        System.arraycopy(this.idData, 0, target.idData, 0, this.idData.length);
        System.arraycopy(this.propertyData, 0, target.propertyData, 0, this.propertyData.length);
        System.arraycopy(this.idListData, 0, target.idListData, 0, this.idListData.length);
    }

    public Embedding copy() {
        Embedding res = new Embedding();
        this.copyTo(res);
        return res;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int sizeBuffer = source.readInt();
        target.writeInt(sizeBuffer);
        target.write(source, sizeBuffer);
        sizeBuffer = source.readInt();
        target.writeInt(sizeBuffer);
        target.write(source, sizeBuffer);
        sizeBuffer = source.readInt();
        target.writeInt(sizeBuffer);
        target.write(source, sizeBuffer);
    }

    public void write(DataOutputView out) throws IOException {
        out.writeInt(this.idData.length);
        out.write(this.idData);
        out.writeInt(this.propertyData.length);
        out.write(this.propertyData);
        out.writeInt(this.idListData.length);
        out.write(this.idListData);
    }

    public void read(DataInputView in) throws IOException {
        int sizeBuffer = in.readInt();
        byte[] ids = new byte[sizeBuffer];
        if (sizeBuffer > 0 && in.read(ids) != sizeBuffer) {
            throw new RuntimeException("Deserialisation of Embedding failed");
        }
        sizeBuffer = in.readInt();
        byte[] newPropertyData = new byte[sizeBuffer];
        if (sizeBuffer > 0 && in.read(newPropertyData) != sizeBuffer) {
            throw new RuntimeException("Deserialisation of Embedding failed");
        }
        sizeBuffer = in.readInt();
        byte[] idLists = new byte[sizeBuffer];
        if (sizeBuffer > 0 && in.read(idLists) != sizeBuffer) {
            throw new RuntimeException("Deserialisation of Embedding failed");
        }
        this.idData = ids;
        this.propertyData = newPropertyData;
        this.idListData = idLists;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Embedding that = (Embedding)o;
        if (!Arrays.equals(this.idData, that.idData)) {
            return false;
        }
        if (!Arrays.equals(this.propertyData, that.propertyData)) {
            return false;
        }
        return Arrays.equals(this.idListData, that.idListData);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.idData);
        result = 31 * result + Arrays.hashCode(this.propertyData);
        result = 31 * result + Arrays.hashCode(this.idListData);
        return result;
    }

    public String toString() {
        ArrayList<List<GradoopId>> idCollection = new ArrayList<List<GradoopId>>();
        for (int i = 0; i < this.size(); ++i) {
            idCollection.add(this.getIdAsList(i));
        }
        String idString = idCollection.stream().map(entry -> {
            if (entry.size() == 1) {
                return ((GradoopId)entry.get(0)).toString();
            }
            return entry.stream().map(GradoopId::toString).collect(Collectors.joining(", ", "[", "]"));
        }).collect(Collectors.joining(", "));
        String propertyString = this.getProperties().stream().map(PropertyValue::toString).collect(Collectors.joining(", "));
        return "Embedding{ entries: {" + idString + "},  properties: {" + propertyString + "} }";
    }
}

