/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos;

import java.util.List;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphElement;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Embedding;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos.Triple;

public class EmbeddingFactory {
    public static Embedding fromVertex(Vertex vertex, List<String> propertyKeys) {
        Embedding embedding = new Embedding();
        embedding.add(vertex.getId(), EmbeddingFactory.project((GraphElement)vertex, propertyKeys));
        return embedding;
    }

    public static Embedding fromEdge(Edge edge, List<String> propertyKeys, boolean isLoop) {
        Embedding embedding = new Embedding();
        if (isLoop) {
            embedding.addAll(edge.getSourceId(), edge.getId());
        } else {
            embedding.addAll(edge.getSourceId(), edge.getId(), edge.getTargetId());
        }
        embedding.addPropertyValues(EmbeddingFactory.project((GraphElement)edge, propertyKeys));
        return embedding;
    }

    public static Embedding fromTriple(Triple triple, List<String> sourcePropertyKeys, List<String> edgePropertyKeys, List<String> targetPropertyKeys, String sourceVertexVariable, String targetVertexVariable) {
        Embedding embedding = new Embedding();
        embedding.add(triple.getSourceVertex().getId(), EmbeddingFactory.project((GraphElement)triple.getSourceVertex(), sourcePropertyKeys));
        embedding.add(triple.getEdge().getId(), EmbeddingFactory.project((GraphElement)triple.getEdge(), edgePropertyKeys));
        if (sourceVertexVariable.equals(targetVertexVariable)) {
            return embedding;
        }
        embedding.add(triple.getTargetVertex().getId(), EmbeddingFactory.project((GraphElement)triple.getTargetVertex(), targetPropertyKeys));
        return embedding;
    }

    private static PropertyValue[] project(GraphElement element, List<String> propertyKeys) {
        PropertyValue[] propertyValues = new PropertyValue[propertyKeys.size()];
        int i = 0;
        for (String propertyKey : propertyKeys) {
            if (propertyKey.equals("__label__")) {
                propertyValues[i++] = PropertyValue.create((Object)element.getLabel());
                continue;
            }
            propertyValues[i++] = element.hasProperty(propertyKey) ? element.getPropertyValue(propertyKey) : PropertyValue.NULL_VALUE;
        }
        return propertyValues;
    }
}

