/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.cypher.pojos;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.gradoop.flink.model.impl.operators.matching.single.cypher.utils.ExpandDirection;

public class EmbeddingMetaData
implements Serializable {
    private Map<Pair<String, EntryType>, Integer> entryMapping;
    private Map<Pair<String, String>, Integer> propertyMapping;
    private Map<String, ExpandDirection> directionMapping;

    public EmbeddingMetaData() {
        this(new HashMap<Pair<String, EntryType>, Integer>(), new HashMap<Pair<String, String>, Integer>(), new HashMap<String, ExpandDirection>());
    }

    public EmbeddingMetaData(Map<Pair<String, EntryType>, Integer> entryMapping, Map<Pair<String, String>, Integer> propertyMapping, Map<String, ExpandDirection> directionMapping) {
        this.entryMapping = entryMapping;
        this.propertyMapping = propertyMapping;
        this.directionMapping = directionMapping;
    }

    public EmbeddingMetaData(EmbeddingMetaData metaData) {
        this.entryMapping = new HashMap<Pair<String, EntryType>, Integer>(metaData.getEntryCount());
        this.propertyMapping = new HashMap<Pair<String, String>, Integer>(metaData.getPropertyCount());
        this.directionMapping = new HashMap<String, ExpandDirection>(metaData.getPathCount());
        metaData.getVariables().forEach(var -> {
            this.entryMapping.put((Pair<String, EntryType>)Pair.of((Object)var, (Object)((Object)metaData.getEntryType((String)var))), metaData.getEntryColumn((String)var));
            metaData.getPropertyKeys((String)var).forEach(key -> this.propertyMapping.put((Pair<String, String>)Pair.of((Object)var, (Object)key), metaData.getPropertyColumn((String)var, (String)key)));
            if (metaData.getEntryType((String)var) == EntryType.PATH) {
                this.directionMapping.put((String)var, metaData.getDirection((String)var));
            }
        });
    }

    public Map<Pair<String, EntryType>, Integer> getEntryMapping() {
        return this.entryMapping;
    }

    public Map<Pair<String, String>, Integer> getPropertyMapping() {
        return this.propertyMapping;
    }

    public Map<String, ExpandDirection> getDirectionMapping() {
        return this.directionMapping;
    }

    public int getEntryCount() {
        return this.entryMapping.size();
    }

    public int getPropertyCount() {
        return this.propertyMapping.size();
    }

    public int getPathCount() {
        return this.directionMapping.size();
    }

    public void setEntryColumn(String variable, EntryType entryType, int column) {
        this.entryMapping.put((Pair<String, EntryType>)Pair.of((Object)variable, (Object)((Object)entryType)), column);
    }

    public int getEntryColumn(String variable) {
        return this.entryMapping.get(Pair.of((Object)variable, (Object)((Object)this.getEntryType(variable))));
    }

    public boolean containsEntryColumn(String variable) {
        return Arrays.stream(EntryType.values()).anyMatch(entryType -> this.entryMapping.containsKey(Pair.of((Object)variable, (Object)entryType)));
    }

    public EntryType getEntryType(String variable) {
        Optional<EntryType> result = Arrays.stream(EntryType.values()).filter(entryType -> this.entryMapping.containsKey(Pair.of((Object)variable, (Object)entryType))).findFirst();
        if (!result.isPresent()) {
            throw new NoSuchElementException(String.format("no entry for variable %s", variable));
        }
        return result.get();
    }

    public void setPropertyColumn(String variable, String propertyKey, int index) {
        this.propertyMapping.put((Pair<String, String>)Pair.of((Object)variable, (Object)propertyKey), index);
    }

    public int getPropertyColumn(String variable, String propertyKey) {
        Integer column = this.propertyMapping.get(Pair.of((Object)variable, (Object)propertyKey));
        if (column == null) {
            throw new NoSuchElementException(String.format("no value for property %s.%s", variable, propertyKey));
        }
        return column;
    }

    public void setDirection(String variable, ExpandDirection direction) {
        this.directionMapping.put(variable, direction);
    }

    public ExpandDirection getDirection(String variable) {
        ExpandDirection expandDirection = this.directionMapping.get(variable);
        if (expandDirection == null) {
            throw new NoSuchElementException("No direction for: " + variable);
        }
        return expandDirection;
    }

    public List<String> getVariables() {
        return this.entryMapping.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> (String)((Pair)entry.getKey()).getLeft()).collect(Collectors.toList());
    }

    public List<String> getVariablesWithProperties() {
        return this.propertyMapping.keySet().stream().map(Pair::getLeft).distinct().collect(Collectors.toList());
    }

    public List<String> getVertexVariables() {
        return this.getVariables(entry -> entry == EntryType.VERTEX);
    }

    public List<String> getEdgeVariables() {
        return this.getVariables(entry -> entry == EntryType.EDGE);
    }

    public List<String> getPathVariables() {
        return this.getVariables(entry -> entry == EntryType.PATH);
    }

    public List<String> getPropertyKeys(String variable) {
        return this.propertyMapping.entrySet().stream().filter(entry -> ((String)((Pair)entry.getKey()).getLeft()).equals(variable)).sorted(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> (String)((Pair)entry.getKey()).getRight()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmbeddingMetaData metaData = (EmbeddingMetaData)o;
        return this.entryMapping.equals(metaData.entryMapping) && this.propertyMapping.equals(metaData.propertyMapping);
    }

    public int hashCode() {
        return 31 * this.entryMapping.hashCode() + this.propertyMapping.hashCode();
    }

    public String toString() {
        List sortedEntries = this.entryMapping.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).collect(Collectors.toList());
        List sortiedProperties = this.propertyMapping.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).collect(Collectors.toList());
        return String.format("EmbeddingMetaData{entryMapping=%s, propertyMapping=%s}", sortedEntries, sortiedProperties);
    }

    private List<String> getVariables(Predicate<EntryType> predicate) {
        return this.entryMapping.entrySet().stream().filter(entry -> predicate.test((EntryType)((Object)((Pair)entry.getKey()).getRight()))).sorted(Comparator.comparingInt(Map.Entry::getValue)).map(entry -> (String)((Pair)entry.getKey()).getLeft()).collect(Collectors.toList());
    }

    public static enum EntryType {
        VERTEX,
        EDGE,
        PATH;

    }
}

