/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative;

import java.util.Objects;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.SingleInputUdfOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.log4j.Logger;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.EdgeFactory;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.GraphHeadFactory;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.api.entities.VertexFactory;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.epgm.BaseGraphFactory;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.VertexFromId;
import org.gradoop.flink.model.impl.functions.tuple.ObjectTo1;
import org.gradoop.flink.model.impl.functions.tuple.Value0Of2;
import org.gradoop.flink.model.impl.functions.tuple.Value1Of2;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.PostProcessor;
import org.gradoop.flink.model.impl.operators.matching.common.PreProcessor;
import org.gradoop.flink.model.impl.operators.matching.common.functions.AddGraphElementToNewGraph;
import org.gradoop.flink.model.impl.operators.matching.common.functions.ElementsFromEmbedding;
import org.gradoop.flink.model.impl.operators.matching.common.functions.MatchingVertices;
import org.gradoop.flink.model.impl.operators.matching.common.query.DFSTraverser;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.common.query.Traverser;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.Embedding;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.single.PatternMatching;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.SetPairBulkTraverser;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.SetPairForLoopTraverser;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.SetPairTraverser;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.TraverserStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.TripleForLoopTraverser;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.TripleTraverser;

public class ExplorativePatternMatching<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
extends PatternMatching<G, V, E, LG, GC> {
    public static final String BC_SUPERSTEP = "bc_superstep";
    private static final Logger LOG = Logger.getLogger(ExplorativePatternMatching.class);
    private final Traverser traverser;
    private final JoinOperatorBase.JoinHint edgeStepJoinStrategy;
    private final JoinOperatorBase.JoinHint vertexStepJoinStrategy;
    private final MatchStrategy matchStrategy;
    private final TraverserStrategy traverserStrategy;

    private ExplorativePatternMatching(String query, boolean attachData, MatchStrategy matchStrategy, TraverserStrategy traverserStrategy, Traverser traverser, JoinOperatorBase.JoinHint edgeStepJoinStrategy, JoinOperatorBase.JoinHint vertexStepJoinStrategy) {
        super(query, attachData, LOG);
        this.matchStrategy = matchStrategy;
        this.traverserStrategy = traverserStrategy;
        this.traverser = traverser;
        this.traverser.setQueryHandler(this.getQueryHandler());
        this.edgeStepJoinStrategy = edgeStepJoinStrategy;
        this.vertexStepJoinStrategy = vertexStepJoinStrategy;
    }

    @Override
    protected GC executeForVertex(LG graph) {
        BaseGraphFactory graphFactory = graph.getFactory();
        GraphHeadFactory graphHeadFactory = graphFactory.getGraphHeadFactory();
        VertexFactory vertexFactory = graphFactory.getVertexFactory();
        String variable = this.getQueryHandler().getVertices().iterator().next().getVariable();
        FilterOperator matchingVertices = graph.getVertices().filter(new MatchingVertices(this.getQuery()));
        if (!this.doAttachData()) {
            matchingVertices = matchingVertices.map(new Id()).map(new ObjectTo1()).map(new VertexFromId(vertexFactory));
        }
        SingleInputUdfOperator pairs = matchingVertices.map(new AddGraphElementToNewGraph(graphHeadFactory, variable)).returns((TypeInformation)new TupleTypeInfo(new TypeInformation[]{TypeExtractor.getForClass((Class)vertexFactory.getType()), TypeExtractor.getForClass((Class)graphHeadFactory.getType())}));
        return graph.getCollectionFactory().fromDataSets(pairs.map(new Value1Of2()), pairs.map(new Value0Of2()));
    }

    @Override
    protected GC executeForPattern(LG graph) {
        DataSet<Tuple1<Embedding<GradoopId>>> embeddings;
        TraversalCode traversalCode = this.traverser.traverse();
        if (this.traverserStrategy == TraverserStrategy.SET_PAIR_BULK_ITERATION || this.traverserStrategy == TraverserStrategy.SET_PAIR_FOR_LOOP_ITERATION) {
            DataSet<IdWithCandidates<GradoopId>> vertices = PreProcessor.filterVertices(graph, this.getQuery());
            DataSet<TripleWithCandidates<GradoopId>> edges = PreProcessor.filterEdges(graph, this.getQuery());
            SetPairTraverser distributedTraverser = this.traverserStrategy == TraverserStrategy.SET_PAIR_BULK_ITERATION ? new SetPairBulkTraverser<GradoopId>(traversalCode, this.matchStrategy, this.traverser.getQueryHandler().getVertexCount(), this.traverser.getQueryHandler().getEdgeCount(), GradoopId.class, this.edgeStepJoinStrategy, this.vertexStepJoinStrategy, this.getVertexMapping(), this.getEdgeMapping()) : new SetPairForLoopTraverser<GradoopId>(traversalCode, this.matchStrategy, this.traverser.getQueryHandler().getVertexCount(), this.traverser.getQueryHandler().getEdgeCount(), GradoopId.class, this.edgeStepJoinStrategy, this.vertexStepJoinStrategy, this.getVertexMapping(), this.getEdgeMapping());
            embeddings = distributedTraverser.traverse(vertices, edges);
        } else if (this.traverserStrategy == TraverserStrategy.TRIPLES_FOR_LOOP_ITERATION) {
            DataSet<TripleWithCandidates<GradoopId>> triples = PreProcessor.filterTriplets(graph, this.getQuery());
            TripleForLoopTraverser<GradoopId> distributedTraverser = new TripleForLoopTraverser<GradoopId>(traversalCode, this.matchStrategy, this.traverser.getQueryHandler().getVertexCount(), this.traverser.getQueryHandler().getEdgeCount(), GradoopId.class, this.edgeStepJoinStrategy, this.getVertexMapping(), this.getEdgeMapping());
            embeddings = ((TripleTraverser)distributedTraverser).traverse(triples);
        } else {
            throw new IllegalArgumentException("Unsupported traverser strategy: " + (Object)((Object)this.traverserStrategy));
        }
        FlatMapOperator elements = embeddings.flatMap((FlatMapFunction)new ElementsFromEmbedding(traversalCode, (GraphHeadFactory<? extends GraphHead>)graph.getFactory().getGraphHeadFactory(), (VertexFactory<? extends Vertex>)graph.getFactory().getVertexFactory(), (EdgeFactory<? extends Edge>)graph.getFactory().getEdgeFactory(), this.getQueryHandler()));
        return this.doAttachData() ? PostProcessor.extractGraphCollectionWithData((DataSet<Element>)elements, graph, true) : PostProcessor.extractGraphCollection((DataSet<Element>)elements, graph.getCollectionFactory(), true);
    }

    public static final class Builder {
        private String query;
        private boolean attachData = false;
        private MatchStrategy matchStrategy = MatchStrategy.ISOMORPHISM;
        private TraverserStrategy traverserStrategy = TraverserStrategy.SET_PAIR_BULK_ITERATION;
        private Traverser traverser = new DFSTraverser();
        private JoinOperatorBase.JoinHint edgeStepJoinStrategy = JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES;
        private JoinOperatorBase.JoinHint vertexStepJoinStrategy = JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES;

        public Builder setQuery(String query) {
            this.query = query;
            return this;
        }

        public Builder setAttachData(boolean attachData) {
            this.attachData = attachData;
            return this;
        }

        public Builder setMatchStrategy(MatchStrategy matchStrategy) {
            this.matchStrategy = matchStrategy;
            return this;
        }

        public Builder setTraverserStrategy(TraverserStrategy traverserStrategy) {
            this.traverserStrategy = traverserStrategy;
            return this;
        }

        public Builder setTraverser(Traverser traverser) {
            this.traverser = traverser;
            return this;
        }

        public Builder setEdgeStepJoinStrategy(JoinOperatorBase.JoinHint edgeStepJoinStrategy) {
            this.edgeStepJoinStrategy = edgeStepJoinStrategy;
            return this;
        }

        public Builder setVertexStepJoinStrategy(JoinOperatorBase.JoinHint vertexStepJoinStrategy) {
            this.vertexStepJoinStrategy = vertexStepJoinStrategy;
            return this;
        }

        public <G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>> ExplorativePatternMatching<G, V, E, LG, GC> build() {
            Objects.requireNonNull(this.query, "Missing GDL query");
            Objects.requireNonNull(this.matchStrategy, "Missing match strategy");
            Objects.requireNonNull(this.traverserStrategy, "Missing iteration strategy");
            Objects.requireNonNull(this.traverser, "Missing traverser");
            Objects.requireNonNull(this.edgeStepJoinStrategy, "Missing join strategy");
            Objects.requireNonNull(this.vertexStepJoinStrategy, "Missing join strategy");
            return new ExplorativePatternMatching(this.query, this.attachData, this.matchStrategy, this.traverserStrategy, this.traverser, this.edgeStepJoinStrategy, this.vertexStepJoinStrategy);
        }
    }
}

