/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions;

import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EdgeStep;

public class BuildEdgeStep<K>
extends RichMapFunction<TripleWithCandidates<K>, EdgeStep<K>> {
    private final EdgeStep<K> reuseTuple;
    private final TraversalCode traversalCode;
    private boolean isOutgoing;

    public BuildEdgeStep(TraversalCode traversalCode) {
        this.traversalCode = traversalCode;
        this.reuseTuple = new EdgeStep();
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        int step = (Integer)this.getRuntimeContext().getBroadcastVariable("bc_superstep").get(0);
        this.isOutgoing = this.traversalCode.getStep(step - 1).isOutgoing();
    }

    public EdgeStep<K> map(TripleWithCandidates<K> t) throws Exception {
        this.reuseTuple.setEdgeId(t.getEdgeId());
        this.reuseTuple.setTiePointId(this.isOutgoing ? t.getSourceId() : t.getTargetId());
        this.reuseTuple.setNextId(this.isOutgoing ? t.getTargetId() : t.getSourceId());
        return this.reuseTuple;
    }
}

