/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions;

import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.query.Step;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.BuildEmbedding;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EmbeddingWithTiePoint;

public class BuildEmbeddingFromTriple<K>
extends BuildEmbedding<K>
implements FlatMapFunction<TripleWithCandidates<K>, EmbeddingWithTiePoint<K>> {
    private final MatchStrategy matchStrategy;
    private final int sourceIndex;
    private final int edgeIndex;
    private final int targetIndex;
    private int nextFrom;
    private boolean isQueryLoop;

    public BuildEmbeddingFromTriple(Class<K> keyClazz, TraversalCode traversalCode, MatchStrategy matchStrategy, long vertexCount, long edgeCount) {
        super(keyClazz, vertexCount, edgeCount);
        this.matchStrategy = matchStrategy;
        Step step = traversalCode.getStep(0);
        boolean isOutgoing = step.isOutgoing();
        this.edgeIndex = (int)step.getVia();
        this.sourceIndex = isOutgoing ? (int)step.getFrom() : (int)step.getTo();
        this.targetIndex = isOutgoing ? (int)step.getTo() : (int)step.getFrom();
        boolean bl = this.isQueryLoop = this.sourceIndex == this.targetIndex;
        if (traversalCode.getSteps().size() > 1) {
            this.nextFrom = (int)traversalCode.getStep(1).getFrom();
        }
    }

    public void flatMap(TripleWithCandidates<K> triple, Collector<EmbeddingWithTiePoint<K>> out) throws Exception {
        if (this.isValidTriple(triple)) {
            this.reuseEmbedding.getEdgeMapping()[this.edgeIndex] = triple.getEdgeId();
            this.reuseEmbedding.getVertexMapping()[this.sourceIndex] = triple.getSourceId();
            this.reuseEmbedding.getVertexMapping()[this.targetIndex] = triple.getTargetId();
            this.reuseEmbeddingWithTiePoint.setTiePointId(this.reuseEmbedding.getVertexMapping()[this.nextFrom]);
            out.collect((Object)this.reuseEmbeddingWithTiePoint);
        }
    }

    private boolean isValidTriple(TripleWithCandidates<K> triple) {
        return this.matchStrategy == MatchStrategy.HOMOMORPHISM || this.isQueryLoop && triple.getSourceId().equals(triple.getTargetId()) || !this.isQueryLoop && !triple.getSourceId().equals(triple.getTargetId());
    }
}

