/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.UpdateMapping;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.TraverserStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EdgeStep;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EmbeddingWithTiePoint;

@FunctionAnnotation.ReadFieldsFirst(value={"f1.f1"})
@FunctionAnnotation.ReadFieldsSecond(value={"f0;f2"})
@FunctionAnnotation.ForwardedFieldsFirst(value={"f1.f0"})
@FunctionAnnotation.ForwardedFieldsSecond(value={"f2->f0"})
public class UpdateEdgeMapping<K>
extends UpdateMapping<K>
implements FlatJoinFunction<EmbeddingWithTiePoint<K>, EdgeStep<K>, EmbeddingWithTiePoint<K>> {
    private final TraverserStrategy traverserStrategy;
    private int edgeCandidate;

    public UpdateEdgeMapping(TraversalCode traversalCode, MatchStrategy matchStrategy, TraverserStrategy traverserStrategy) {
        super(traversalCode, matchStrategy);
        this.traverserStrategy = traverserStrategy;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        if (this.traverserStrategy == TraverserStrategy.SET_PAIR_BULK_ITERATION) {
            this.setCurrentStepId(this.getIterationRuntimeContext().getSuperstepNumber() - 1);
        } else if (this.traverserStrategy == TraverserStrategy.SET_PAIR_FOR_LOOP_ITERATION) {
            this.setCurrentStepId((Integer)this.getRuntimeContext().getBroadcastVariable("bc_superstep").get(0) - 1);
        }
        this.initializeVisited();
        this.edgeCandidate = (int)this.getCurrentStep().getVia();
    }

    public void join(EmbeddingWithTiePoint<K> embedding, EdgeStep<K> edgeStep, Collector<EmbeddingWithTiePoint<K>> collector) throws Exception {
        K[] edgeMapping;
        K edgeId = edgeStep.getEdgeId();
        if (this.isValidEdge(edgeId, edgeMapping = embedding.getEmbedding().getEdgeMapping(), this.edgeCandidate)) {
            edgeMapping[this.edgeCandidate] = edgeId;
            embedding.getEmbedding().setEdgeMapping(edgeMapping);
            embedding.setTiePointId(edgeStep.getNextId());
            collector.collect(embedding);
        }
    }
}

