/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions;

import java.util.HashSet;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.query.Step;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;

abstract class UpdateMapping<K>
extends AbstractRichFunction {
    private final TraversalCode traversalCode;
    private final MatchStrategy matchStrategy;
    private final int stepCount;
    private int currentStepId;
    private boolean hasMoreSteps;
    private int[] previousEdgeCandidates;
    private int[] previousVertexCandidates;

    UpdateMapping(TraversalCode traversalCode, MatchStrategy matchStrategy) {
        this.traversalCode = traversalCode;
        this.matchStrategy = matchStrategy;
        this.stepCount = traversalCode.getSteps().size();
    }

    private boolean seenBefore(K[] mapping, K id, int[] fields) {
        boolean result = false;
        for (int field : fields) {
            if (!mapping[field].equals(id)) continue;
            result = true;
            break;
        }
        return result;
    }

    void initializeVisited() {
        if (this.getMatchStrategy() == MatchStrategy.ISOMORPHISM) {
            int i;
            this.previousEdgeCandidates = new int[this.currentStepId];
            for (int i2 = 0; i2 < this.currentStepId; ++i2) {
                this.previousEdgeCandidates[i2] = (int)this.getTraversalCode().getStep(i2).getVia();
            }
            HashSet<Integer> visitedVertices = new HashSet<Integer>(this.stepCount * 2);
            for (i = 0; i < this.currentStepId; ++i) {
                Step s = this.getTraversalCode().getStep(i);
                visitedVertices.add((int)s.getFrom());
                visitedVertices.add((int)s.getTo());
            }
            visitedVertices.add((int)this.getCurrentStep().getFrom());
            this.previousVertexCandidates = new int[visitedVertices.size()];
            i = 0;
            for (Integer visitedVertex : visitedVertices) {
                this.previousVertexCandidates[i++] = visitedVertex;
            }
        }
    }

    TraversalCode getTraversalCode() {
        return this.traversalCode;
    }

    MatchStrategy getMatchStrategy() {
        return this.matchStrategy;
    }

    void setCurrentStepId(int currentStepId) {
        this.currentStepId = currentStepId;
        this.hasMoreSteps = currentStepId < this.stepCount - 1;
    }

    Step getCurrentStep() {
        return this.traversalCode.getStep(this.currentStepId);
    }

    boolean hasMoreSteps() {
        return this.hasMoreSteps;
    }

    int getNextFrom() {
        return this.hasMoreSteps() ? (int)this.getTraversalCode().getStep(this.currentStepId + 1).getFrom() : -1;
    }

    boolean isValidVertex(K vertexId, K[] vertexMapping, int candidateIndex) {
        boolean isMapped = vertexMapping[candidateIndex] != null;
        boolean seen = this.matchStrategy == MatchStrategy.ISOMORPHISM && this.seenBefore(vertexMapping, vertexId, this.previousVertexCandidates);
        return !isMapped && !seen || isMapped && vertexMapping[candidateIndex].equals(vertexId);
    }

    boolean isValidEdge(K edgeId, K[] edgeMapping, int candidateIndex) {
        boolean isMapped = edgeMapping[candidateIndex] != null;
        boolean seen = this.getMatchStrategy() == MatchStrategy.ISOMORPHISM && this.seenBefore(edgeMapping, edgeId, this.previousEdgeCandidates);
        return !isMapped && !seen;
    }
}

