/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.query.Step;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.UpdateMapping;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EmbeddingWithTiePoint;

public class UpdateVertexEdgeMapping<K>
extends UpdateMapping<K>
implements FlatJoinFunction<EmbeddingWithTiePoint<K>, TripleWithCandidates<K>, EmbeddingWithTiePoint<K>> {
    private final int sourceCandidate;
    private final int edgeCandidate;
    private final int targetCandidate;
    private int nextFrom;

    public UpdateVertexEdgeMapping(TraversalCode traversalCode, int currentStepId, MatchStrategy matchStrategy) {
        super(traversalCode, matchStrategy);
        this.setCurrentStepId(currentStepId);
        this.initializeVisited();
        Step currentStep = this.getCurrentStep();
        boolean isOutgoing = currentStep.isOutgoing();
        this.edgeCandidate = (int)currentStep.getVia();
        this.sourceCandidate = isOutgoing ? (int)currentStep.getFrom() : (int)currentStep.getTo();
        this.targetCandidate = isOutgoing ? (int)currentStep.getTo() : (int)currentStep.getFrom();
        this.nextFrom = this.getNextFrom();
    }

    public void join(EmbeddingWithTiePoint<K> embedding, TripleWithCandidates<K> t, Collector<EmbeddingWithTiePoint<K>> out) throws Exception {
        K[] edgeMapping;
        K edgeId = t.getEdgeId();
        if (this.isValidEdge(edgeId, edgeMapping = embedding.getEmbedding().getEdgeMapping(), this.edgeCandidate)) {
            K[] vertexMapping = embedding.getEmbedding().getVertexMapping();
            if (this.isValidVertex(t.getSourceId(), vertexMapping, this.sourceCandidate) && this.isValidVertex(t.getTargetId(), vertexMapping, this.targetCandidate)) {
                edgeMapping[this.edgeCandidate] = edgeId;
                vertexMapping[this.sourceCandidate] = t.getSourceId();
                vertexMapping[this.targetCandidate] = t.getTargetId();
                if (this.hasMoreSteps()) {
                    embedding.setTiePointId(vertexMapping[this.nextFrom]);
                }
                out.collect(embedding);
            }
        }
    }
}

