/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions;

import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.UpdateMapping;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.TraverserStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EmbeddingWithTiePoint;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.VertexStep;

@FunctionAnnotation.ReadFieldsFirst(value={"f1.f0"})
@FunctionAnnotation.ReadFieldsSecond(value={"f0"})
public class UpdateVertexMapping<K>
extends UpdateMapping<K>
implements FlatJoinFunction<EmbeddingWithTiePoint<K>, VertexStep<K>, EmbeddingWithTiePoint<K>> {
    private final TraverserStrategy traverserStrategy;
    private int nextFrom;
    private int vertexCandidate;

    public UpdateVertexMapping(TraversalCode tc, MatchStrategy matchStrategy, TraverserStrategy traverserStrategy) {
        super(tc, matchStrategy);
        this.traverserStrategy = traverserStrategy;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        if (this.traverserStrategy == TraverserStrategy.SET_PAIR_BULK_ITERATION) {
            this.setCurrentStepId(this.getIterationRuntimeContext().getSuperstepNumber() - 1);
        } else if (this.traverserStrategy == TraverserStrategy.SET_PAIR_FOR_LOOP_ITERATION) {
            this.setCurrentStepId((Integer)this.getRuntimeContext().getBroadcastVariable("bc_superstep").get(0) - 1);
        }
        this.initializeVisited();
        this.vertexCandidate = (int)this.getCurrentStep().getTo();
        this.nextFrom = this.getNextFrom();
    }

    public void join(EmbeddingWithTiePoint<K> embedding, VertexStep<K> vertexStep, Collector<EmbeddingWithTiePoint<K>> collector) throws Exception {
        K[] vertexMapping;
        K vertexId = vertexStep.getVertexId();
        if (this.isValidVertex(vertexId, vertexMapping = embedding.getEmbedding().getVertexMapping(), this.vertexCandidate)) {
            vertexMapping[this.vertexCandidate] = vertexId;
            embedding.getEmbedding().setVertexMapping(vertexMapping);
            if (this.hasMoreSteps()) {
                embedding.setTiePointId(vertexMapping[this.nextFrom]);
            }
            collector.collect(embedding);
        }
    }
}

