/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser;

import java.util.Objects;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.debug.Printer;
import org.gradoop.flink.model.impl.operators.matching.common.functions.ElementHasCandidate;
import org.gradoop.flink.model.impl.operators.matching.common.query.Step;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.Embedding;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.debug.PrintEdgeStep;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.debug.PrintEmbeddingWithTiePoint;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.debug.PrintVertexStep;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.BuildEdgeStep;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.BuildEmbeddingFromVertex;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.BuildVertexStep;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.EdgeHasCandidate;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.UpdateEdgeMapping;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.UpdateVertexMapping;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.VertexHasCandidate;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.DistributedTraverser;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.TraverserStrategy;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EmbeddingWithTiePoint;

public abstract class SetPairTraverser<K>
extends DistributedTraverser<K> {
    private final JoinOperatorBase.JoinHint edgeStepJoinStrategy;
    private final JoinOperatorBase.JoinHint vertexStepJoinStrategy;

    SetPairTraverser(TraversalCode traversalCode, MatchStrategy matchStrategy, int vertexCount, int edgeCount, Class<K> keyClazz, JoinOperatorBase.JoinHint edgeStepJoinStrategy, JoinOperatorBase.JoinHint vertexStepJoinStrategy, DataSet<Tuple2<K, PropertyValue>> vertexMapping, DataSet<Tuple2<K, PropertyValue>> edgeMapping) {
        super(traversalCode, matchStrategy, vertexCount, edgeCount, keyClazz, vertexMapping, edgeMapping);
        Objects.requireNonNull(edgeStepJoinStrategy);
        Objects.requireNonNull(vertexStepJoinStrategy);
        this.edgeStepJoinStrategy = edgeStepJoinStrategy;
        this.vertexStepJoinStrategy = vertexStepJoinStrategy;
    }

    public abstract DataSet<Tuple1<Embedding<K>>> traverse(DataSet<IdWithCandidates<K>> var1, DataSet<TripleWithCandidates<K>> var2);

    private JoinOperatorBase.JoinHint getEdgeStepJoinStrategy() {
        return this.edgeStepJoinStrategy;
    }

    private JoinOperatorBase.JoinHint getVertexStepJoinStrategy() {
        return this.vertexStepJoinStrategy;
    }

    DataSet<EmbeddingWithTiePoint<K>> buildInitialEmbeddings(DataSet<IdWithCandidates<K>> vertices) {
        Step initialStep = this.getTraversalCode().getStep(0);
        MapOperator initialEmbeddings = vertices.filter(new ElementHasCandidate((int)initialStep.getFrom())).map(new BuildEmbeddingFromVertex(this.getKeyClazz(), initialStep, this.getVertexCount(), this.getEdgeCount()));
        return Printer.log(initialEmbeddings, new PrintEmbeddingWithTiePoint(), this.getVertexMapping(), this.getEdgeMapping());
    }

    DataSet<EmbeddingWithTiePoint<K>> traverseEdges(DataSet<TripleWithCandidates<K>> edges, DataSet<EmbeddingWithTiePoint<K>> embeddings, DataSet<Integer> superstep, TraverserStrategy traverserStrategy, String[] forwardedFields) {
        DataSet edgeSteps = ((MapOperator)((FilterOperator)edges.filter(new EdgeHasCandidate(this.getTraversalCode())).withBroadcastSet(superstep, "bc_superstep")).map(new BuildEdgeStep(this.getTraversalCode())).withBroadcastSet(superstep, "bc_superstep")).withForwardedFields(forwardedFields);
        edgeSteps = Printer.log(edgeSteps, new PrintEdgeStep(this.isIterative(), "post-filter-map-edge"), this.getVertexMapping(), this.getEdgeMapping());
        JoinOperator.EquiJoin join = embeddings.join(edgeSteps, this.getEdgeStepJoinStrategy()).where(new int[]{0}).equalTo(new int[]{1}).with(new UpdateEdgeMapping(this.getTraversalCode(), this.getMatchStrategy(), traverserStrategy));
        embeddings = traverserStrategy == TraverserStrategy.SET_PAIR_FOR_LOOP_ITERATION ? join.withBroadcastSet(superstep, "bc_superstep") : join;
        return Printer.log(embeddings, new PrintEmbeddingWithTiePoint(this.isIterative(), "post-edge-update"), this.getVertexMapping(), this.getEdgeMapping());
    }

    DataSet<EmbeddingWithTiePoint<K>> traverseVertices(DataSet<IdWithCandidates<K>> vertices, DataSet<EmbeddingWithTiePoint<K>> embeddings, DataSet<Integer> superstep, TraverserStrategy traverserStrategy) {
        DataSet vertexSteps = ((FilterOperator)vertices.filter(new VertexHasCandidate(this.getTraversalCode())).withBroadcastSet(superstep, "bc_superstep")).map(new BuildVertexStep());
        vertexSteps = Printer.log(vertexSteps, new PrintVertexStep(this.isIterative(), "post-filter-project-vertex"), this.getVertexMapping(), this.getEdgeMapping());
        DataSet join = embeddings.join(vertexSteps, this.getVertexStepJoinStrategy()).where(new int[]{0}).equalTo(new int[]{0}).with(new UpdateVertexMapping(this.getTraversalCode(), this.getMatchStrategy(), traverserStrategy));
        embeddings = traverserStrategy == TraverserStrategy.SET_PAIR_FOR_LOOP_ITERATION ? join.withBroadcastSet(superstep, "bc_superstep") : join;
        embeddings = Printer.log(embeddings, new PrintEmbeddingWithTiePoint(this.isIterative(), "post-vertex-update"), this.getVertexMapping(), this.getEdgeMapping());
        return embeddings;
    }
}

