/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser;

import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.tuple.Tuple1;
import org.apache.flink.api.java.tuple.Tuple2;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.impl.operators.matching.common.MatchStrategy;
import org.gradoop.flink.model.impl.operators.matching.common.debug.PrintTripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.debug.Printer;
import org.gradoop.flink.model.impl.operators.matching.common.functions.TripleHasCandidate;
import org.gradoop.flink.model.impl.operators.matching.common.query.Step;
import org.gradoop.flink.model.impl.operators.matching.common.query.TraversalCode;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.Embedding;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.debug.PrintEmbeddingWithTiePoint;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.functions.UpdateVertexEdgeMapping;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.traverser.TripleTraverser;
import org.gradoop.flink.model.impl.operators.matching.single.preserving.explorative.tuples.EmbeddingWithTiePoint;

public class TripleForLoopTraverser<K>
extends TripleTraverser<K> {
    public TripleForLoopTraverser(TraversalCode traversalCode, int vertexCount, int edgeCount, Class<K> keyClazz) {
        this(traversalCode, MatchStrategy.ISOMORPHISM, vertexCount, edgeCount, keyClazz, JoinOperatorBase.JoinHint.OPTIMIZER_CHOOSES, null, null);
    }

    public TripleForLoopTraverser(TraversalCode traversalCode, MatchStrategy matchStrategy, int vertexCount, int edgeCount, Class<K> keyClazz, JoinOperatorBase.JoinHint edgeStepJoinStrategy, DataSet<Tuple2<K, PropertyValue>> vertexMapping, DataSet<Tuple2<K, PropertyValue>> edgeMapping) {
        super(traversalCode, matchStrategy, vertexCount, edgeCount, keyClazz, edgeStepJoinStrategy, vertexMapping, edgeMapping);
    }

    @Override
    public DataSet<Tuple1<Embedding<K>>> traverse(DataSet<TripleWithCandidates<K>> triples) {
        return this.iterate(triples, this.buildInitialEmbeddings(triples)).project(new int[]{1});
    }

    @Override
    boolean isIterative() {
        return false;
    }

    private DataSet<EmbeddingWithTiePoint<K>> iterate(DataSet<TripleWithCandidates<K>> triples, DataSet<EmbeddingWithTiePoint<K>> embeddings) {
        TraversalCode traversalCode = this.getTraversalCode();
        for (int i = 1; i < traversalCode.getSteps().size(); ++i) {
            Step step = traversalCode.getStep(i);
            embeddings = Printer.log(embeddings, new PrintEmbeddingWithTiePoint(i, "pre-join-embeddings"), this.getVertexMapping(), this.getEdgeMapping());
            DataSet filteredTriples = triples.filter(new TripleHasCandidate((int)step.getVia()));
            filteredTriples = Printer.log(filteredTriples, new PrintTripleWithCandidates(i, "pre-join-triples"), this.getVertexMapping(), this.getEdgeMapping());
            embeddings = embeddings.join(filteredTriples, this.getEdgeStepJoinStrategy()).where(new int[]{0}).equalTo(new int[]{step.isOutgoing() ? 1 : 2}).with(new UpdateVertexEdgeMapping(traversalCode, i, this.getMatchStrategy()));
        }
        return Printer.log(embeddings, new PrintEmbeddingWithTiePoint(this.isIterative(), "final-embeddings"), this.getVertexMapping(), this.getEdgeMapping());
    }
}

