/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.functions;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.flink.api.common.functions.RichGroupCombineFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.FatVertex;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.IdPair;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.TripleWithDirection;

public class BuildFatVertex
extends RichGroupCombineFunction<TripleWithDirection, FatVertex> {
    private static final long serialVersionUID = 42L;
    private final FatVertex reuseVertex;
    private final String query;
    private transient QueryHandler qHandler;

    public BuildFatVertex(String query) {
        this.query = query;
        this.reuseVertex = new FatVertex();
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.qHandler = new QueryHandler(this.query);
    }

    public void combine(Iterable<TripleWithDirection> triples, Collector<FatVertex> collector) throws Exception {
        boolean first = true;
        for (TripleWithDirection triple : triples) {
            if (first) {
                this.initFatVertex(triple);
                first = false;
            }
            if (triple.isOutgoing().booleanValue()) {
                this.processOutgoingEdgeTriple(triple);
                continue;
            }
            this.processIncomingEdgeTriple(triple);
        }
        collector.collect((Object)this.reuseVertex);
    }

    private void initFatVertex(TripleWithDirection triple) {
        this.reuseVertex.setVertexId(triple.getSourceId());
        this.reuseVertex.setCandidates(Lists.newArrayList());
        this.reuseVertex.setParentIds(Lists.newArrayList());
        this.reuseVertex.setIncomingCandidateCounts(new int[this.qHandler.getEdgeCount()]);
        this.reuseVertex.setEdgeCandidates(Maps.newHashMap());
        this.reuseVertex.setUpdated(true);
    }

    private void processOutgoingEdgeTriple(TripleWithDirection triple) {
        for (int eQ = 0; eQ < triple.getCandidates().length; ++eQ) {
            if (!triple.getCandidates()[eQ]) continue;
            this.updateCandidates(this.qHandler.getEdgeById(Long.valueOf(eQ)).getSourceVertexId());
        }
        this.updateOutgoingEdges(triple);
    }

    private void updateCandidates(Long candidate) {
        if (!this.reuseVertex.getCandidates().contains(candidate)) {
            this.reuseVertex.getCandidates().add(candidate);
        }
    }

    private void updateOutgoingEdges(TripleWithDirection triple) {
        IdPair idPair = new IdPair();
        idPair.setEdgeId(triple.getEdgeId());
        idPair.setTargetId(triple.getTargetId());
        this.reuseVertex.getEdgeCandidates().put(idPair, triple.getCandidates());
    }

    private void processIncomingEdgeTriple(TripleWithDirection triple) {
        for (int eQ = 0; eQ < triple.getCandidates().length; ++eQ) {
            if (!triple.getCandidates()[eQ]) continue;
            int[] nArray = this.reuseVertex.getIncomingCandidateCounts();
            int n = eQ;
            nArray[n] = nArray[n] + 1;
            this.updateParentIds(triple);
            this.updateCandidates(this.qHandler.getEdgeById(Long.valueOf(eQ)).getTargetVertexId());
        }
    }

    private void updateParentIds(TripleWithDirection triple) {
        if (!this.reuseVertex.getParentIds().contains(triple.getTargetId())) {
            this.reuseVertex.getParentIds().add(triple.getTargetId());
        }
    }
}

