/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.functions;

import com.google.common.collect.Lists;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.Deletion;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.Message;

@FunctionAnnotation.ForwardedFields(value={"f0"})
public class CombinedMessages
implements GroupCombineFunction<Deletion, Message> {
    private final Message reuseMessage = new Message();

    public void combine(Iterable<Deletion> deletions, Collector<Message> collector) {
        this.reuseMessage.setSenderIds(Lists.newArrayList());
        this.reuseMessage.setDeletions(Lists.newArrayList());
        this.reuseMessage.setMessageTypes(Lists.newArrayList());
        boolean first = true;
        for (Deletion deletion : deletions) {
            if (first) {
                this.reuseMessage.setRecipientId(deletion.getRecipientId());
                first = false;
            }
            this.reuseMessage.getSenderIds().add(deletion.getSenderId());
            this.reuseMessage.getDeletions().add(deletion.getDeletion());
            this.reuseMessage.getMessageTypes().add(deletion.getMessageType());
        }
        collector.collect((Object)this.reuseMessage);
    }
}

