/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.functions;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.util.Collector;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.FatVertex;

@FunctionAnnotation.ForwardedFields(value={"f0"})
@FunctionAnnotation.ReadFields(value={"f1;f2;f3;f4"})
public class GroupedFatVertices
implements GroupReduceFunction<FatVertex, FatVertex> {
    public void reduce(Iterable<FatVertex> vertices, Collector<FatVertex> collector) throws Exception {
        boolean first = true;
        FatVertex result = null;
        for (FatVertex vertex : vertices) {
            if (first) {
                result = vertex;
                first = false;
                continue;
            }
            result = this.merge(result, vertex);
        }
        collector.collect(result);
    }

    private FatVertex merge(FatVertex result, FatVertex diff) {
        if (diff.getCandidates().removeAll(result.getCandidates())) {
            result.getCandidates().addAll(diff.getCandidates());
        }
        result.getParentIds().addAll(diff.getParentIds());
        for (int i = 0; i < diff.getIncomingCandidateCounts().length; ++i) {
            int[] nArray = result.getIncomingCandidateCounts();
            int n = i;
            nArray[n] = nArray[n] + diff.getIncomingCandidateCounts()[i];
        }
        result.getEdgeCandidates().putAll(diff.getEdgeCandidates());
        return result;
    }
}

