/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.functions;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.functions.RichJoinFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.FatVertex;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.IdPair;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.Message;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.util.MessageType;

@FunctionAnnotation.ForwardedFieldsFirst(value={"f0"})
public class UpdateVertexState
extends RichJoinFunction<FatVertex, Message, FatVertex> {
    private static final long serialVersionUID = 42L;
    private final String query;
    private transient QueryHandler queryHandler;

    public UpdateVertexState(String query) {
        this.query = query;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.queryHandler = new QueryHandler(this.query);
    }

    public FatVertex join(FatVertex fatVertex, Message message) throws Exception {
        if (message != null) {
            for (int i = 0; i < message.getSenderIds().size(); ++i) {
                this.processDeletion(fatVertex, message.getSenderIds().get(i), message.getDeletions().get(i), message.getMessageTypes().get(i));
            }
            fatVertex.setUpdated(true);
        } else {
            fatVertex.setUpdated(false);
        }
        return fatVertex;
    }

    private void processDeletion(FatVertex fatVertex, GradoopId senderId, Long deletion, MessageType messageType) {
        switch (messageType) {
            case FROM_SELF: {
                this.updateCandidates(fatVertex, deletion);
                break;
            }
            case FROM_CHILD: {
                this.updateOutgoingEdges(fatVertex, this.queryHandler.getEdgeIdsByTargetVertexId(deletion), senderId);
                break;
            }
            case FROM_PARENT: {
                this.updateIncomingEdges(fatVertex, this.queryHandler.getEdgeIdsBySourceVertexId(deletion));
                break;
            }
            case FROM_CHILD_REMOVE: {
                this.updateOutgoingEdges(fatVertex, senderId);
                break;
            }
            case FROM_PARENT_REMOVE: {
                this.updateIncomingEdges(fatVertex, this.queryHandler.getEdgeIdsBySourceVertexId(deletion));
                this.updateParentIds(fatVertex, senderId);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)messageType));
            }
        }
    }

    private void updateParentIds(FatVertex fatVertex, GradoopId senderId) {
        fatVertex.getParentIds().remove(senderId);
    }

    private void updateCandidates(FatVertex fatVertex, Long deletion) {
        fatVertex.getCandidates().remove(deletion);
        if (!fatVertex.getCandidates().isEmpty()) {
            this.updateOutgoingEdges(fatVertex, this.queryHandler.getEdgeIdsBySourceVertexId(deletion));
        }
    }

    private void updateIncomingEdges(FatVertex fatVertex, Collection<Long> queryEdges) {
        for (Long eQ : queryEdges) {
            if (fatVertex.getIncomingCandidateCounts()[eQ.intValue()] <= 0) continue;
            int[] nArray = fatVertex.getIncomingCandidateCounts();
            int n = eQ.intValue();
            nArray[n] = nArray[n] - 1;
        }
    }

    private void updateOutgoingEdges(FatVertex vertex, GradoopId targetId) {
        Iterator<IdPair> iterator = vertex.getEdgeCandidates().keySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getTargetId().equals((Object)targetId)) continue;
            iterator.remove();
        }
    }

    private void updateOutgoingEdges(FatVertex fatVertex, Collection<Long> queryEdges) {
        this.updateOutgoingEdges(fatVertex, queryEdges, null);
    }

    private void updateOutgoingEdges(FatVertex fatVertex, Collection<Long> queryEdges, GradoopId targetVertex) {
        if (queryEdges != null) {
            Iterator<Map.Entry<IdPair, boolean[]>> edgeIterator = fatVertex.getEdgeCandidates().entrySet().iterator();
            while (edgeIterator.hasNext()) {
                Map.Entry<IdPair, boolean[]> e = edgeIterator.next();
                if (targetVertex != null && !e.getKey().getTargetId().equals((Object)targetVertex)) continue;
                for (Long eQ : queryEdges) {
                    e.getValue()[eQ.intValue()] = false;
                }
                if (!this.allFalse(e.getValue())) continue;
                edgeIterator.remove();
            }
        }
    }

    private boolean allFalse(boolean[] a) {
        for (boolean b : a) {
            if (!b) continue;
            return false;
        }
        return true;
    }
}

