/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.functions;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.functions.RichFlatMapFunction;
import org.apache.flink.api.java.functions.FunctionAnnotation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.hadoop.shaded.com.google.common.collect.Lists;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.Deletion;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.FatVertex;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.tuples.IdPair;
import org.gradoop.flink.model.impl.operators.matching.single.simulation.dual.util.MessageType;
import org.s1ck.gdl.model.Edge;

@FunctionAnnotation.ForwardedFields(value={"f0->f1"})
public class ValidateNeighborhood
extends RichFlatMapFunction<FatVertex, Deletion> {
    private static final long serialVersionUID = 42L;
    private final String query;
    private transient QueryHandler queryHandler;
    private final Deletion reuseDeletion;

    public ValidateNeighborhood(String query) {
        this.query = query;
        this.reuseDeletion = new Deletion();
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.queryHandler = new QueryHandler(this.query);
    }

    public void flatMap(FatVertex fatVertex, Collector<Deletion> collector) throws Exception {
        ArrayList deletions = Lists.newArrayListWithCapacity((int)fatVertex.getCandidates().size());
        Set<Long> outgoingEdgeCandidates = this.getOutgoingEdgeCandidates(fatVertex);
        for (Long vQ : fatVertex.getCandidates()) {
            if (this.isValidCandidate(vQ, fatVertex, outgoingEdgeCandidates)) continue;
            deletions.add(vQ);
        }
        if (!deletions.isEmpty()) {
            this.sendDeletions(deletions, fatVertex, collector);
        }
    }

    private boolean isValidCandidate(Long vQ, FatVertex fatVertex, Set<Long> outgoingEdgeCandidates) {
        boolean isValidChild = this.isValidChild(vQ, fatVertex);
        boolean isValidParent = true;
        if (isValidChild) {
            isValidParent = this.isValidParent(vQ, outgoingEdgeCandidates);
        }
        return isValidChild && isValidParent;
    }

    private boolean isValidChild(Long vQ, FatVertex fatVertex) {
        boolean isValidChild = true;
        Collection<Edge> inE = this.queryHandler.getEdgesByTargetVertexId(vQ);
        if (inE != null) {
            for (Edge eQIn : inE) {
                if (fatVertex.getIncomingCandidateCounts()[(int)eQIn.getId()] != 0) continue;
                isValidChild = false;
                break;
            }
        }
        return isValidChild;
    }

    private boolean isValidParent(Long vQ, Set<Long> outgoingEdgeCandidates) {
        boolean isValidParent = true;
        Collection<Edge> outE = this.queryHandler.getEdgesBySourceVertexId(vQ);
        if (outE != null) {
            for (Edge eQOut : outE) {
                if (outgoingEdgeCandidates.contains(eQOut.getId())) continue;
                isValidParent = false;
                break;
            }
        }
        return isValidParent;
    }

    private void sendDeletions(List<Long> deletions, FatVertex fatVertex, Collector<Deletion> collector) {
        this.reuseDeletion.setSenderId(fatVertex.getVertexId());
        boolean toBeRemoved = deletions.size() == fatVertex.getCandidates().size();
        for (Long deletion : deletions) {
            this.reuseDeletion.setDeletion(deletion);
            this.sendToSelf(fatVertex, collector);
            this.sendToParents(fatVertex, collector, toBeRemoved);
            this.sendToChildren(fatVertex, collector, toBeRemoved);
        }
    }

    private void sendToSelf(FatVertex fatVertex, Collector<Deletion> collector) {
        this.reuseDeletion.setMessageType(MessageType.FROM_SELF);
        this.reuseDeletion.setRecipientId(fatVertex.getVertexId());
        collector.collect((Object)this.reuseDeletion);
    }

    private void sendToParents(FatVertex fatVertex, Collector<Deletion> collector, boolean toBeRemoved) {
        this.reuseDeletion.setMessageType(toBeRemoved ? MessageType.FROM_CHILD_REMOVE : MessageType.FROM_CHILD);
        for (GradoopId gradoopId : fatVertex.getParentIds()) {
            this.reuseDeletion.setRecipientId(gradoopId);
            collector.collect((Object)this.reuseDeletion);
        }
    }

    private void sendToChildren(FatVertex fatVertex, Collector<Deletion> collector, boolean toBeRemoved) {
        this.reuseDeletion.setMessageType(toBeRemoved ? MessageType.FROM_PARENT_REMOVE : MessageType.FROM_PARENT);
        for (IdPair idPair : fatVertex.getEdgeCandidates().keySet()) {
            this.reuseDeletion.setRecipientId(idPair.getTargetId());
            collector.collect((Object)this.reuseDeletion);
        }
    }

    private Set<Long> getOutgoingEdgeCandidates(FatVertex fatVertex) {
        HashSet outgoingEdgeCandidates = Sets.newHashSet();
        for (boolean[] candidates : fatVertex.getEdgeCandidates().values()) {
            for (int i = 0; i < candidates.length; ++i) {
                if (!candidates[i]) continue;
                outgoingEdgeCandidates.add(Long.valueOf(i));
            }
        }
        return outgoingEdgeCandidates;
    }
}

