/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.transactional;

import org.apache.flink.api.common.functions.CoGroupFunction;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.CoGroupOperator;
import org.apache.flink.api.java.operators.FlatMapOperator;
import org.apache.flink.api.java.operators.GroupReduceOperator;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.GraphHead;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.flink.model.api.epgm.BaseGraph;
import org.gradoop.flink.model.api.epgm.BaseGraphCollection;
import org.gradoop.flink.model.api.operators.UnaryBaseGraphCollectionToBaseGraphCollectionOperator;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.tuple.Project4To0And1;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;
import org.gradoop.flink.model.impl.operators.matching.common.functions.MatchingEdges;
import org.gradoop.flink.model.impl.operators.matching.common.functions.MatchingVertices;
import org.gradoop.flink.model.impl.operators.matching.transactional.algorithm.PatternMatchingAlgorithm;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.AddGraphsToElements;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.AddMatchesToProperties;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.BuildGraphWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.BuildIdWithCandidatesAndGraphs;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.BuildTripleWithCandidatesAndGraphs;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.ExpandFirstField;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.FindEmbeddings;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.HasEmbeddings;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.InitGraphHeadWithLineage;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.MergeSecondField;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.Project4To0And2AndSwitch;
import org.gradoop.flink.model.impl.operators.matching.transactional.function.Project4To0And3AndSwitch;
import org.gradoop.flink.model.impl.operators.matching.transactional.tuples.GraphWithCandidates;

public class TransactionalPatternMatching<G extends GraphHead, V extends Vertex, E extends Edge, LG extends BaseGraph<G, V, E, LG, GC>, GC extends BaseGraphCollection<G, V, E, LG, GC>>
implements UnaryBaseGraphCollectionToBaseGraphCollectionOperator<GC> {
    private String query;
    private PatternMatchingAlgorithm algorithm;
    private boolean findEmbeddings;

    public TransactionalPatternMatching(String query, PatternMatchingAlgorithm algorithm, boolean findEmbeddings) {
        this.query = query;
        this.algorithm = algorithm;
        this.findEmbeddings = findEmbeddings;
    }

    @Override
    public GC execute(GC collection) {
        MapOperator graphIds = collection.getGraphHeads().map(new Id());
        JoinOperator.EquiJoin vertexCandidatesWithGraphs = collection.getVertices().filter(new MatchingVertices(this.query)).map(new BuildIdWithCandidatesAndGraphs(this.query)).flatMap(new ExpandFirstField()).join((DataSet)graphIds).where(new int[]{0}).equalTo(new String[]{"*"}).with(new LeftSide());
        JoinOperator.EquiJoin edgeCandidatesWithGraphs = collection.getEdges().filter(new MatchingEdges(this.query)).map(new BuildTripleWithCandidatesAndGraphs(this.query)).flatMap(new ExpandFirstField()).join((DataSet)graphIds).where(new int[]{0}).equalTo(new String[]{"*"}).with(new LeftSide());
        CoGroupOperator graphs = vertexCandidatesWithGraphs.coGroup((DataSet)edgeCandidatesWithGraphs).where(new int[]{0}).equalTo(new int[]{0}).with((CoGroupFunction)new BuildGraphWithCandidates());
        if (this.findEmbeddings) {
            return this.findEmbeddings(collection, (DataSet<GraphWithCandidates>)graphs);
        }
        return this.hasEmbeddings(collection, (DataSet<GraphWithCandidates>)graphs);
    }

    private GC hasEmbeddings(GC collection, DataSet<GraphWithCandidates> graphs) {
        MapOperator matches = graphs.map((MapFunction)new HasEmbeddings(this.algorithm, this.query));
        CoGroupOperator newHeads = collection.getGraphHeads().coGroup((DataSet)matches).where(new Id()).equalTo(new int[]{0}).with(new AddMatchesToProperties());
        return collection.getFactory().fromDataSets(newHeads, collection.getVertices(), collection.getEdges());
    }

    private GC findEmbeddings(GC collection, DataSet<GraphWithCandidates> graphs) {
        FlatMapOperator embeddings = graphs.flatMap((FlatMapFunction)new FindEmbeddings(this.algorithm, this.query));
        MapOperator newHeads = embeddings.map(new Project4To0And1()).map(new InitGraphHeadWithLineage(collection.getFactory().getGraphHeadFactory()));
        GroupReduceOperator verticesWithGraphs = embeddings.map(new Project4To0And2AndSwitch()).flatMap(new ExpandFirstField()).groupBy(new int[]{0}).reduceGroup(new MergeSecondField());
        JoinOperator.EquiJoin newVertices = verticesWithGraphs.join(collection.getVertices()).where(new int[]{0}).equalTo(new Id()).with(new AddGraphsToElements());
        GroupReduceOperator edgesWithGraphs = embeddings.map(new Project4To0And3AndSwitch()).flatMap(new ExpandFirstField()).groupBy(new int[]{0}).reduceGroup(new MergeSecondField());
        JoinOperator.EquiJoin newEdges = edgesWithGraphs.join(collection.getEdges()).where(new int[]{0}).equalTo(new Id()).with(new AddGraphsToElements());
        return collection.getFactory().fromDataSets(newHeads, newVertices, newEdges);
    }
}

