/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.transactional.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.flink.api.java.tuple.Tuple3;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.Embedding;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.transactional.algorithm.PatternMatchingAlgorithm;
import org.gradoop.flink.model.impl.operators.matching.transactional.tuples.GraphWithCandidates;
import org.s1ck.gdl.model.Edge;
import org.s1ck.gdl.model.Vertex;

public class DepthSearchMatching
implements PatternMatchingAlgorithm {
    private static final long serialVersionUID = 42L;
    private Map<GradoopId, boolean[]> vertexDict = new HashMap<GradoopId, boolean[]>();
    private Map<GradoopId, Set<GradoopId>> sourceDict = new HashMap<GradoopId, Set<GradoopId>>();
    private Map<GradoopId, Set<GradoopId>> targetDict = new HashMap<GradoopId, Set<GradoopId>>();
    private Map<GradoopId, Tuple3<GradoopId, GradoopId, boolean[]>> edgeDict = new HashMap<GradoopId, Tuple3<GradoopId, GradoopId, boolean[]>>();
    private transient QueryHandler handler;

    @Override
    public List<Embedding<GradoopId>> findEmbeddings(GraphWithCandidates graph, String query) {
        this.handler = new QueryHandler(query);
        int[] plan = this.buildQueryPlan();
        Stack embeddings = new Stack();
        Embedding<GradoopId> firstEmbedding = new Embedding<GradoopId>();
        firstEmbedding.setVertexMapping(new GradoopId[this.handler.getVertexCount()]);
        firstEmbedding.setEdgeMapping(new GradoopId[this.handler.getEdgeCount()]);
        embeddings.push(firstEmbedding);
        this.initializeMaps(graph);
        ArrayList<Embedding<GradoopId>> results = new ArrayList<Embedding<GradoopId>>();
        while (!embeddings.isEmpty()) {
            Embedding embedding = (Embedding)((Object)embeddings.pop());
            int nextStep = -1;
            for (int step : plan) {
                if (((GradoopId[])embedding.getVertexMapping())[step] != null) continue;
                nextStep = step;
                break;
            }
            if (nextStep == -1) {
                results.add(embedding);
                continue;
            }
            List<Embedding<GradoopId>> newEmbeddings = this.executeStep(embedding, nextStep);
            embeddings.addAll(newEmbeddings);
        }
        this.resetMaps();
        return results;
    }

    @Override
    public Boolean hasEmbedding(GraphWithCandidates graph, String query) {
        this.handler = new QueryHandler(query);
        int[] plan = this.buildQueryPlan();
        Stack embeddings = new Stack();
        Embedding<GradoopId> firstEmbedding = new Embedding<GradoopId>();
        firstEmbedding.setVertexMapping(new GradoopId[this.handler.getVertexCount()]);
        firstEmbedding.setEdgeMapping(new GradoopId[this.handler.getEdgeCount()]);
        embeddings.push(firstEmbedding);
        this.initializeMaps(graph);
        while (!embeddings.isEmpty()) {
            Embedding embedding = (Embedding)((Object)embeddings.pop());
            int nextStep = -1;
            for (int step : plan) {
                if (((GradoopId[])embedding.getVertexMapping())[step] != null) continue;
                nextStep = step;
                break;
            }
            if (nextStep == -1) {
                this.resetMaps();
                return true;
            }
            List<Embedding<GradoopId>> newEmbeddings = this.executeStep(embedding, nextStep);
            embeddings.addAll(newEmbeddings);
        }
        this.resetMaps();
        return false;
    }

    private void resetMaps() {
        this.vertexDict.clear();
        this.edgeDict.clear();
        this.sourceDict.clear();
        this.targetDict.clear();
    }

    private List<Embedding<GradoopId>> executeStep(Embedding<GradoopId> embedding, int step) {
        HashMap<Long, Set<GradoopId>> edgeMatches = new HashMap<Long, Set<GradoopId>>();
        ArrayList<Embedding<GradoopId>> results = new ArrayList<Embedding<GradoopId>>();
        for (GradoopId id : this.getCandidates(step)) {
            Tuple3<GradoopId, GradoopId, boolean[]> edgeCandidate;
            HashSet edgeCandidateIds;
            boolean failed = false;
            if (Arrays.asList(embedding.getVertexMapping()).contains(id)) continue;
            Collection<Edge> edges = this.handler.getEdgesBySourceVertexId(Long.valueOf(step));
            ArrayList<Edge> patternEdges = edges != null ? new ArrayList<Edge>(edges) : new ArrayList();
            this.filterPatternEdges(patternEdges, embedding);
            for (Edge patternEdge : patternEdges) {
                edgeMatches.put(patternEdge.getId(), new HashSet());
                edgeCandidateIds = this.sourceDict.get(id) != null ? this.sourceDict.get(id) : new HashSet();
                for (GradoopId edgeCandidateId : edgeCandidateIds) {
                    edgeCandidate = this.edgeDict.get(edgeCandidateId);
                    GradoopId target = embedding.getVertexMapping()[Math.toIntExact(patternEdge.getTargetVertexId())];
                    if (this.isLoop(patternEdge, edgeCandidate)) {
                        ((Set)edgeMatches.get(patternEdge.getId())).add(edgeCandidateId);
                        continue;
                    }
                    if (!this.matchOutgoingEdge(patternEdge, edgeCandidateId, target)) continue;
                    ((Set)edgeMatches.get(patternEdge.getId())).add(edgeCandidateId);
                }
                if (!((Set)edgeMatches.get(patternEdge.getId())).isEmpty()) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            edges = this.handler.getEdgesByTargetVertexId(Long.valueOf(step));
            patternEdges = edges != null ? new ArrayList<Edge>(edges) : new ArrayList();
            this.filterPatternEdges(patternEdges, embedding);
            for (Edge patternEdge : patternEdges) {
                edgeMatches.put(patternEdge.getId(), new HashSet());
                edgeCandidateIds = this.targetDict.get(id) != null ? this.targetDict.get(id) : new HashSet();
                for (GradoopId edgeCandidateId : edgeCandidateIds) {
                    edgeCandidate = this.edgeDict.get(edgeCandidateId);
                    GradoopId source = embedding.getVertexMapping()[Math.toIntExact(patternEdge.getSourceVertexId())];
                    if (this.isLoop(patternEdge, edgeCandidate)) {
                        ((Set)edgeMatches.get(patternEdge.getId())).add(edgeCandidateId);
                        continue;
                    }
                    if (!this.matchIncomingEdge(patternEdge, edgeCandidateId, source)) continue;
                    ((Set)edgeMatches.get(patternEdge.getId())).add(edgeCandidateId);
                }
                if (!((Set)edgeMatches.get(patternEdge.getId())).isEmpty()) continue;
                failed = true;
                break;
            }
            if (failed) continue;
            results.addAll(this.buildNewEmbeddings(embedding, step, id, edgeMatches));
        }
        return results;
    }

    private boolean isLoop(Edge patternEdge, Tuple3<GradoopId, GradoopId, boolean[]> edgeCandidate) {
        if (patternEdge.getSourceVertexId().equals(patternEdge.getTargetVertexId()) && ((GradoopId)edgeCandidate.f0).equals(edgeCandidate.f1)) {
            return ((boolean[])edgeCandidate.f2)[(int)patternEdge.getId()];
        }
        return false;
    }

    private List<Edge> filterPatternEdges(List<Edge> patternEdges, Embedding<GradoopId> embedding) {
        for (int i = 0; i < patternEdges.size(); ++i) {
            long sourceId = patternEdges.get(i).getSourceVertexId();
            long targetId = patternEdges.get(i).getTargetVertexId();
            GradoopId[] vertexMapping = embedding.getVertexMapping();
            if (vertexMapping[(int)sourceId] != null || vertexMapping[(int)targetId] != null || sourceId == targetId) continue;
            patternEdges.remove(i);
            --i;
        }
        return patternEdges;
    }

    private List<Embedding<GradoopId>> buildNewEmbeddings(Embedding<GradoopId> startEmbedding, int step, GradoopId vertexMatch, Map<Long, Set<GradoopId>> edgeMatches) {
        ArrayList<Embedding<Object>> result = new ArrayList<Embedding<GradoopId>>();
        result.add(startEmbedding);
        ArrayList<Map.Entry<Long, Set<GradoopId>>> entries = new ArrayList<Map.Entry<Long, Set<GradoopId>>>(edgeMatches.entrySet());
        if (entries.isEmpty()) {
            Embedding<GradoopId> newEmbedding = this.copyEmbedding(startEmbedding);
            newEmbedding.getVertexMapping()[step] = vertexMatch;
            result.clear();
            result.add(newEmbedding);
        }
        for (Map.Entry entry : entries) {
            ArrayList<Embedding<GradoopId>> temporaryEmbeddings = new ArrayList<Embedding<GradoopId>>();
            for (Embedding embedding : result) {
                for (GradoopId id : (Set)entry.getValue()) {
                    boolean contains = false;
                    for (GradoopId edgeId : (GradoopId[])embedding.getEdgeMapping()) {
                        if (edgeId == null || !edgeId.equals((Object)id)) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    Embedding<GradoopId> newEmbedding = this.copyEmbedding(embedding);
                    newEmbedding.getVertexMapping()[step] = vertexMatch;
                    newEmbedding.getEdgeMapping()[Math.toIntExact((long)((Long)entry.getKey()).longValue())] = id;
                    temporaryEmbeddings.add(newEmbedding);
                }
            }
            result = new ArrayList(temporaryEmbeddings);
        }
        return result;
    }

    private Embedding<GradoopId> copyEmbedding(Embedding<GradoopId> existing) {
        Embedding<GradoopId> newEmbedding = new Embedding<GradoopId>();
        GradoopId[] vertexCopy = new GradoopId[existing.getVertexMapping().length];
        System.arraycopy(existing.getVertexMapping(), 0, vertexCopy, 0, existing.getVertexMapping().length);
        GradoopId[] edgeCopy = new GradoopId[existing.getEdgeMapping().length];
        System.arraycopy(existing.getEdgeMapping(), 0, edgeCopy, 0, existing.getEdgeMapping().length);
        newEmbedding.setVertexMapping(vertexCopy);
        newEmbedding.setEdgeMapping(edgeCopy);
        return newEmbedding;
    }

    public List<GradoopId> getCandidates(int step) {
        ArrayList<GradoopId> possibilities = new ArrayList<GradoopId>(this.vertexDict.keySet());
        for (int i = 0; i < possibilities.size(); ++i) {
            GradoopId vertexId = (GradoopId)possibilities.get(i);
            boolean[] candidates = this.vertexDict.get(vertexId);
            if (candidates[step]) continue;
            possibilities.remove(i);
            --i;
        }
        return possibilities;
    }

    private boolean matchOutgoingEdge(Edge patternEdge, GradoopId edgeCandidate, GradoopId target) {
        Tuple3<GradoopId, GradoopId, boolean[]> edge = this.edgeDict.get(edgeCandidate);
        if (((boolean[])edge.f2)[(int)patternEdge.getId()]) {
            GradoopId possibleVertex = (GradoopId)edge.f1;
            return possibleVertex.equals((Object)target);
        }
        return false;
    }

    private boolean matchIncomingEdge(Edge patternEdge, GradoopId edgeCandidate, GradoopId source) {
        Tuple3<GradoopId, GradoopId, boolean[]> edge = this.edgeDict.get(edgeCandidate);
        if (((boolean[])edge.f2)[(int)patternEdge.getId()]) {
            GradoopId possibleVertex = (GradoopId)edge.f0;
            return possibleVertex.equals((Object)source);
        }
        return false;
    }

    private void initializeMaps(GraphWithCandidates graph) {
        for (IdWithCandidates<GradoopId> idWithCandidates : graph.getVertexCandidates()) {
            this.vertexDict.put(idWithCandidates.getId(), idWithCandidates.getCandidates());
        }
        for (TripleWithCandidates tripleWithCandidates : graph.getEdgeCandidates()) {
            this.edgeDict.put((GradoopId)tripleWithCandidates.getEdgeId(), (Tuple3<GradoopId, GradoopId, boolean[]>)new Tuple3(tripleWithCandidates.getSourceId(), tripleWithCandidates.getTargetId(), (Object)tripleWithCandidates.getCandidates()));
        }
        for (TripleWithCandidates tripleWithCandidates : graph.getEdgeCandidates()) {
            if (!this.sourceDict.containsKey(tripleWithCandidates.getSourceId())) {
                this.sourceDict.put((GradoopId)tripleWithCandidates.getSourceId(), new HashSet());
            }
            this.sourceDict.get(tripleWithCandidates.getSourceId()).add((GradoopId)tripleWithCandidates.getEdgeId());
            if (!this.targetDict.containsKey(tripleWithCandidates.getTargetId())) {
                this.targetDict.put((GradoopId)tripleWithCandidates.getTargetId(), new HashSet());
            }
            this.targetDict.get(tripleWithCandidates.getTargetId()).add((GradoopId)tripleWithCandidates.getEdgeId());
        }
    }

    private int[] buildQueryPlan() {
        int[] queryPlan = new int[this.handler.getVertices().size()];
        int step = 0;
        HashSet<Long> alreadyVisited = new HashSet<Long>();
        Stack<Vertex> stack = new Stack<Vertex>();
        stack.push(this.handler.getVertexById(0L));
        alreadyVisited.add(0L);
        while (!stack.isEmpty()) {
            Vertex current = (Vertex)stack.pop();
            Collection<Vertex> neighbors = this.handler.getNeighbors(current.getId());
            queryPlan[step] = (int)current.getId();
            ++step;
            neighbors.stream().filter(neighbor -> !alreadyVisited.contains(neighbor.getId())).forEach(neighbor -> {
                alreadyVisited.add(neighbor.getId());
                stack.push((Vertex)neighbor);
            });
        }
        return queryPlan;
    }
}

