/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.transactional.function;

import java.util.List;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.id.GradoopIdSet;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.Embedding;
import org.gradoop.flink.model.impl.operators.matching.transactional.algorithm.PatternMatchingAlgorithm;
import org.gradoop.flink.model.impl.operators.matching.transactional.tuples.GraphWithCandidates;

public class FindEmbeddings
implements FlatMapFunction<GraphWithCandidates, Tuple4<GradoopId, GradoopId, GradoopIdSet, GradoopIdSet>> {
    private PatternMatchingAlgorithm algo;
    private String query;

    public FindEmbeddings(PatternMatchingAlgorithm algo, String query) {
        this.algo = algo;
        this.query = query;
    }

    public void flatMap(GraphWithCandidates graphWithCandidates, Collector<Tuple4<GradoopId, GradoopId, GradoopIdSet, GradoopIdSet>> collector) throws Exception {
        List<Embedding<GradoopId>> embeddings = this.algo.findEmbeddings(graphWithCandidates, this.query);
        for (Embedding<GradoopId> embedding : embeddings) {
            GradoopId newGraphId = GradoopId.get();
            collector.collect((Object)new Tuple4((Object)newGraphId, graphWithCandidates.f0, (Object)GradoopIdSet.fromExisting((GradoopId[])embedding.getVertexMapping()), (Object)GradoopIdSet.fromExisting((GradoopId[])embedding.getEdgeMapping())));
        }
    }
}

