/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.matching.transactional.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.configuration.Configuration;
import org.gradoop.common.model.impl.id.GradoopId;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.layouts.transactional.tuples.GraphTransaction;
import org.gradoop.flink.model.impl.operators.matching.common.matching.ElementMatcher;
import org.gradoop.flink.model.impl.operators.matching.common.query.QueryHandler;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.IdWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.common.tuples.TripleWithCandidates;
import org.gradoop.flink.model.impl.operators.matching.transactional.tuples.GraphWithCandidates;

public class GraphTransactionMatcher
extends RichMapFunction<GraphTransaction, GraphWithCandidates> {
    private static final long serialVersionUID = 42L;
    private transient QueryHandler handler;
    private String query;

    public GraphTransactionMatcher(String query) {
        this.query = query;
    }

    public void open(Configuration parameters) throws Exception {
        this.handler = new QueryHandler(this.query);
    }

    public GraphWithCandidates map(GraphTransaction graphTransaction) {
        GraphWithCandidates graph = new GraphWithCandidates(graphTransaction.getGraphHead().getId());
        Set<EPGMVertex> vertices = graphTransaction.getVertices();
        ArrayList<IdWithCandidates<GradoopId>> vertexCandidates = new ArrayList<IdWithCandidates<GradoopId>>(vertices.size());
        for (EPGMVertex vertex : vertices) {
            IdWithCandidates<GradoopId> candidates = new IdWithCandidates<GradoopId>();
            candidates.setId(vertex.getId());
            candidates.setCandidates(this.getCandidates(this.handler.getVertexCount(), ElementMatcher.getMatches(vertex, this.handler.getVertices(), "")));
            vertexCandidates.add(candidates);
        }
        Set<EPGMEdge> edges = graphTransaction.getEdges();
        ArrayList<TripleWithCandidates<GradoopId>> edgeCandidates = new ArrayList<TripleWithCandidates<GradoopId>>(edges.size());
        for (EPGMEdge edge : edges) {
            TripleWithCandidates<GradoopId> candidates = new TripleWithCandidates<GradoopId>();
            candidates.setEdgeId(edge.getId());
            candidates.setSourceId(edge.getSourceId());
            candidates.setTargetId(edge.getTargetId());
            candidates.setCandidates(this.getCandidates(this.handler.getEdgeCount(), ElementMatcher.getMatches(edge, this.handler.getEdges(), "")));
            edgeCandidates.add(candidates);
        }
        graph.setVertexCandidates(vertexCandidates);
        graph.setEdgeCandidates(edgeCandidates);
        return graph;
    }

    private boolean[] getCandidates(int candidateCount, List<Long> matches) {
        boolean[] candidates = new boolean[candidateCount];
        for (Long candidate : matches) {
            candidates[candidate.intValue()] = true;
        }
        return candidates;
    }
}

