/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.neighborhood.functions;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Edge;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.EdgeAggregateFunction;
import org.gradoop.flink.model.impl.operators.neighborhood.functions.NeighborEdgeFunction;

public class NeighborEdgeReduceFunction<E extends Edge, V extends Vertex>
extends NeighborEdgeFunction
implements GroupReduceFunction<Tuple2<E, V>, V> {
    public NeighborEdgeReduceFunction(EdgeAggregateFunction function) {
        super(function);
    }

    public void reduce(Iterable<Tuple2<E, V>> tuples, Collector<V> collector) throws Exception {
        PropertyValue propertyValue = PropertyValue.NULL_VALUE;
        Vertex vertex = null;
        boolean isFirst = true;
        for (Tuple2<E, V> tuple : tuples) {
            Edge edge = (Edge)tuple.f0;
            if (isFirst) {
                vertex = (Vertex)tuple.f1;
                isFirst = false;
                propertyValue = this.getFunction().getIncrement((Element)edge);
                continue;
            }
            propertyValue = this.getFunction().aggregate(propertyValue, this.getFunction().getIncrement((Element)edge));
        }
        if (vertex != null) {
            vertex.setProperty(this.getFunction().getAggregatePropertyKey(), propertyValue);
            collector.collect(vertex);
        }
    }
}

