/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.neighborhood.functions;

import org.apache.flink.api.common.functions.GroupReduceFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Collector;
import org.gradoop.common.model.api.entities.Element;
import org.gradoop.common.model.api.entities.Vertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.VertexAggregateFunction;
import org.gradoop.flink.model.impl.operators.neighborhood.functions.NeighborVertexFunction;

public class NeighborVertexReduceFunction<V extends Vertex>
extends NeighborVertexFunction
implements GroupReduceFunction<Tuple2<V, V>, V> {
    public NeighborVertexReduceFunction(VertexAggregateFunction function) {
        super(function);
    }

    public void reduce(Iterable<Tuple2<V, V>> tuples, Collector<V> collector) throws Exception {
        PropertyValue propertyValue = PropertyValue.NULL_VALUE;
        Vertex vertex = null;
        boolean isFirst = true;
        for (Tuple2<V, V> tuple : tuples) {
            Vertex edgeVertex = (Vertex)tuple.f0;
            if (isFirst) {
                vertex = (Vertex)tuple.f1;
                isFirst = false;
                propertyValue = this.getFunction().getIncrement((Element)edgeVertex);
                continue;
            }
            propertyValue = this.getFunction().aggregate(propertyValue, this.getFunction().getIncrement((Element)edgeVertex));
        }
        if (vertex != null) {
            vertex.setProperty(this.getFunction().getAggregatePropertyKey(), propertyValue);
            collector.collect(vertex);
        }
    }
}

