/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.rollup;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.operators.UnionOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMGraphHead;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.common.model.impl.properties.PropertyValue;
import org.gradoop.flink.model.api.functions.AggregateFunction;
import org.gradoop.flink.model.api.operators.UnaryGraphToCollectionOperator;
import org.gradoop.flink.model.impl.epgm.GraphCollection;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.SetProperty;
import org.gradoop.flink.model.impl.operators.grouping.GroupingStrategy;

public abstract class RollUp
implements UnaryGraphToCollectionOperator {
    protected final List<String> vertexGroupingKeys;
    protected final List<AggregateFunction> vertexAggregateFunctions;
    protected final List<String> edgeGroupingKeys;
    protected final List<AggregateFunction> edgeAggregateFunctions;
    protected GroupingStrategy strategy;

    RollUp(List<String> vertexGroupingKeys, List<AggregateFunction> vertexAggregateFunctions, List<String> edgeGroupingKeys, List<AggregateFunction> edgeAggregateFunctions) {
        this.vertexGroupingKeys = vertexGroupingKeys;
        this.vertexAggregateFunctions = vertexAggregateFunctions;
        this.edgeGroupingKeys = edgeGroupingKeys;
        this.edgeAggregateFunctions = edgeAggregateFunctions;
        this.strategy = GroupingStrategy.GROUP_REDUCE;
    }

    @Override
    public GraphCollection execute(LogicalGraph graph) {
        MapOperator graphHeads = null;
        UnionOperator vertices = null;
        UnionOperator edges = null;
        List<List<String>> groupingKeyCombinations = this.getGroupingKeyCombinations();
        for (List<String> combination : groupingKeyCombinations) {
            LogicalGraph groupedGraph = this.applyGrouping(graph, combination);
            PropertyValue groupingKeys = PropertyValue.create((Object)String.join((CharSequence)",", combination));
            MapOperator newGraphHead = groupedGraph.getGraphHead().map(new SetProperty(this.getGraphPropertyKey(), groupingKeys));
            if (graphHeads != null && vertices != null && edges != null) {
                graphHeads = graphHeads.union((DataSet)newGraphHead);
                vertices = vertices.union(groupedGraph.getVertices());
                edges = edges.union(groupedGraph.getEdges());
                continue;
            }
            graphHeads = newGraphHead;
            vertices = groupedGraph.getVertices();
            edges = groupedGraph.getEdges();
        }
        GraphCollection collection = graphHeads != null && vertices != null && edges != null ? graph.getCollectionFactory().fromDataSets((DataSet<EPGMGraphHead>)graphHeads, (DataSet<EPGMVertex>)vertices, (DataSet<EPGMEdge>)edges) : graph.getCollectionFactory().createEmptyCollection();
        return collection;
    }

    List<List<String>> createGroupingKeyCombinations(List<String> groupingKeys) {
        ArrayList<List<String>> combinations = new ArrayList<List<String>>();
        for (int elements = groupingKeys.size(); elements > 0; --elements) {
            combinations.add(new ArrayList<String>(groupingKeys.subList(0, elements)));
        }
        return combinations;
    }

    public void setGroupingStrategy(GroupingStrategy strategy) {
        this.strategy = strategy;
    }

    abstract String getGraphPropertyKey();

    abstract LogicalGraph applyGrouping(LogicalGraph var1, List<String> var2);

    abstract List<List<String>> getGroupingKeyCombinations();
}

