/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.FilterOperator;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.pagerank.PageRank;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.operators.aggregation.functions.count.VertexCount;
import org.gradoop.flink.model.impl.operators.aggregation.functions.max.MaxVertexProperty;
import org.gradoop.flink.model.impl.operators.aggregation.functions.min.MinVertexProperty;
import org.gradoop.flink.model.impl.operators.aggregation.functions.sum.SumVertexProperty;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.sampling.functions.AddPageRankScoresToVertexCrossFunction;
import org.gradoop.flink.model.impl.operators.sampling.functions.PageRankResultVertexFilter;

public class PageRankSampling
extends SamplingAlgorithm {
    private final double dampeningFactor;
    private final int maxIteration;
    private final double threshold;
    private final boolean sampleGreaterThanThreshold;
    private final boolean keepVerticesIfSameScore;

    public PageRankSampling(double dampeningFactor, int maxIteration, double threshold, boolean sampleGreaterThanThreshold, boolean keepVerticesIfSameScore) {
        this.dampeningFactor = dampeningFactor;
        this.threshold = threshold;
        this.maxIteration = maxIteration;
        this.sampleGreaterThanThreshold = sampleGreaterThanThreshold;
        this.keepVerticesIfSameScore = keepVerticesIfSameScore;
    }

    @Override
    public LogicalGraph sample(LogicalGraph graph) {
        LogicalGraph pageRankGraph = new PageRank("PageRankScore", this.dampeningFactor, this.maxIteration, true).execute(graph);
        graph = graph.getFactory().fromDataSets(graph.getGraphHead(), pageRankGraph.getVertices(), pageRankGraph.getEdges());
        graph = (LogicalGraph)graph.aggregate(new MinVertexProperty("PageRankScore"), new MaxVertexProperty("PageRankScore"), new SumVertexProperty("PageRankScore"), new VertexCount());
        FilterOperator scaledVertices = graph.getVertices().crossWithTiny((DataSet)graph.getGraphHead().first(1)).with((CrossFunction)new AddPageRankScoresToVertexCrossFunction()).filter((FilterFunction)new PageRankResultVertexFilter(this.threshold, this.sampleGreaterThanThreshold, this.keepVerticesIfSameScore));
        return (LogicalGraph)graph.getFactory().fromDataSets((DataSet<EPGMVertex>)scaledVertices, graph.getEdges()).verify();
    }
}

