/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DistinctOperator;
import org.apache.flink.api.java.operators.FilterOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.sampling.functions.RandomFilter;

public class RandomEdgeSampling
extends SamplingAlgorithm {
    private final float sampleSize;
    private final long randomSeed;

    public RandomEdgeSampling(float sampleSize) {
        this(sampleSize, 0L);
    }

    public RandomEdgeSampling(float sampleSize, long randomSeed) {
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
    }

    @Override
    public LogicalGraph sample(LogicalGraph graph) {
        FilterOperator newEdges = graph.getEdges().filter(new RandomFilter(this.sampleSize, this.randomSeed));
        DistinctOperator newSourceVertices = graph.getVertices().join((DataSet)newEdges).where(new Id()).equalTo(new SourceId()).with(new LeftSide()).distinct(new Id());
        DistinctOperator newTargetVertices = graph.getVertices().join((DataSet)newEdges).where(new Id()).equalTo(new TargetId()).with(new LeftSide()).distinct(new Id());
        DistinctOperator newVertices = newSourceVertices.union((DataSet)newTargetVertices).distinct(new Id());
        return graph.getFactory().fromDataSets((DataSet<EPGMVertex>)newVertices, (DataSet<EPGMEdge>)newEdges);
    }
}

