/*
 * Decompiled with CFR 0.152.
 */
package org.gradoop.flink.model.impl.operators.sampling;

import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.JoinOperator;
import org.apache.flink.api.java.operators.MapOperator;
import org.gradoop.common.model.impl.pojo.EPGMEdge;
import org.gradoop.common.model.impl.pojo.EPGMVertex;
import org.gradoop.flink.algorithms.gelly.vertexdegrees.DistinctVertexDegrees;
import org.gradoop.flink.model.impl.epgm.LogicalGraph;
import org.gradoop.flink.model.impl.functions.epgm.Id;
import org.gradoop.flink.model.impl.functions.epgm.PropertyRemover;
import org.gradoop.flink.model.impl.functions.epgm.SourceId;
import org.gradoop.flink.model.impl.functions.epgm.TargetId;
import org.gradoop.flink.model.impl.functions.utils.LeftSide;
import org.gradoop.flink.model.impl.operators.sampling.SamplingAlgorithm;
import org.gradoop.flink.model.impl.operators.sampling.common.SamplingConstants;
import org.gradoop.flink.model.impl.operators.sampling.functions.LimitedDegreeVertexRandomFilter;
import org.gradoop.flink.model.impl.operators.sampling.functions.VertexDegree;

public class RandomLimitedDegreeVertexSampling
extends SamplingAlgorithm {
    private final float sampleSize;
    private final long randomSeed;
    private final long degreeThreshold;
    private final VertexDegree degreeType;

    public RandomLimitedDegreeVertexSampling(float sampleSize) {
        this(sampleSize, 0L);
    }

    public RandomLimitedDegreeVertexSampling(float sampleSize, long randomSeed) {
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
        this.degreeThreshold = 2L;
        this.degreeType = VertexDegree.BOTH;
    }

    public RandomLimitedDegreeVertexSampling(float sampleSize, long randomSeed, long degreeThreshold, VertexDegree degreeType) {
        this.sampleSize = sampleSize;
        this.randomSeed = randomSeed;
        this.degreeThreshold = degreeThreshold;
        this.degreeType = degreeType;
    }

    public RandomLimitedDegreeVertexSampling(float sampleSize, long degreeThreshold, VertexDegree degreeType) {
        this.sampleSize = sampleSize;
        this.randomSeed = 0L;
        this.degreeThreshold = degreeThreshold;
        this.degreeType = degreeType;
    }

    @Override
    public LogicalGraph sample(LogicalGraph graph) {
        graph = new DistinctVertexDegrees(SamplingConstants.DEGREE_PROPERTY_KEY, SamplingConstants.IN_DEGREE_PROPERTY_KEY, SamplingConstants.OUT_DEGREE_PROPERTY_KEY, true).execute(graph);
        MapOperator newVertices = graph.getVertices().filter(new LimitedDegreeVertexRandomFilter(this.sampleSize, this.randomSeed, this.degreeThreshold, this.degreeType)).map(new PropertyRemover(SamplingConstants.DEGREE_PROPERTY_KEY)).map(new PropertyRemover(SamplingConstants.IN_DEGREE_PROPERTY_KEY)).map(new PropertyRemover(SamplingConstants.OUT_DEGREE_PROPERTY_KEY));
        JoinOperator.EquiJoin newEdges = graph.getEdges().join((DataSet)newVertices).where(new SourceId()).equalTo(new Id()).with(new LeftSide()).join((DataSet)newVertices).where(new TargetId()).equalTo(new Id()).with(new LeftSide());
        return graph.getFactory().fromDataSets((DataSet<EPGMVertex>)newVertices, (DataSet<EPGMEdge>)newEdges);
    }
}

